/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.typed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.Key;
import mcjty.incontrol.tools.typed.Type;
import mcjty.incontrol.tools.varia.JSonTools;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class GenericAttributeMapFactory {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public GenericAttributeMapFactory attribute(@Nonnull Attribute a) {
        this.attributes.add(a);
        return this;
    }

    private boolean validate(JsonObject object, String file) {
        Set validKeys = this.attributes.stream().map(a -> a.key().name()).collect(Collectors.toSet());
        HashSet errors = new HashSet();
        object.keySet().forEach(attr -> {
            if (!validKeys.contains(attr)) {
                errors.add(attr);
            }
        });
        if (!errors.isEmpty()) {
            ErrorHandler.error("Invalid keywords for " + file + ": " + StringUtils.join(errors, (char)' '));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public AttributeMap parse(@Nonnull JsonElement element, String file) {
        JsonObject jsonObject = element.getAsJsonObject();
        AttributeMap map = new AttributeMap();
        if (!this.validate(jsonObject, file)) {
            return map;
        }
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            JsonPrimitive prim;
            JsonElement el;
            Attribute attribute = iterator.next();
            Key key = attribute.key();
            Type type = key.type();
            if (attribute.multi()) {
                Function<JsonElement, Object> transformer;
                if (type == Type.INTEGER) {
                    transformer = JsonElement::getAsInt;
                } else if (type == Type.FLOAT) {
                    transformer = JsonElement::getAsFloat;
                } else if (type == Type.BOOLEAN) {
                    transformer = JsonElement::getAsBoolean;
                } else if (type == Type.STRING) {
                    transformer = JsonElement::getAsString;
                } else if (type == Type.JSON) {
                    transformer = JsonElement::toString;
                } else if (type == Type.OBJECT) {
                    if (!jsonObject.isJsonPrimitive()) {
                        ErrorHandler.error("Expected a primitive for " + key.name() + "!");
                        return map;
                    }
                    transformer = jsonObject.getAsJsonPrimitive().isNumber() ? JsonElement::getAsInt : (jsonObject.getAsJsonPrimitive().isBoolean() ? JsonElement::getAsBoolean : JsonElement::getAsString);
                } else {
                    transformer = type == Type.DIMENSION_TYPE ? jsonElement -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)jsonElement.getAsString())) : e -> "INVALID";
                }
                JSonTools.getElement(jsonObject, key.name()).ifPresent(e -> JSonTools.asArrayOrSingle(e).map(transformer).forEach(s -> map.addListNonnull(key, s)));
                continue;
            }
            if (type == Type.INTEGER) {
                map.setNonnull(key, JSonTools.parseInt(jsonObject, key.name()));
                continue;
            }
            if (type == Type.FLOAT) {
                map.setNonnull(key, JSonTools.parseFloat(jsonObject, key.name()));
                continue;
            }
            if (type == Type.BOOLEAN) {
                map.setNonnull(key, JSonTools.parseBool(jsonObject, key.name()));
                continue;
            }
            if (type == Type.STRING) {
                if (!jsonObject.has(key.name())) continue;
                map.setNonnull(key, jsonObject.get(key.name()).getAsString());
                continue;
            }
            if (type == Type.OBJECT) {
                if (!jsonObject.has(key.name())) continue;
                el = jsonObject.get(key.name());
                if (el.isJsonObject()) {
                    map.setNonnull(key, el.getAsJsonObject().toString());
                    continue;
                }
                if (!el.isJsonPrimitive()) continue;
                prim = el.getAsJsonPrimitive();
                if (prim.isString()) {
                    map.setNonnull(key, prim.getAsString());
                    continue;
                }
                if (!prim.isNumber()) {
                    throw new RuntimeException("Bad type for key '" + key.name() + "'!");
                }
                map.setNonnull(key, "" + prim.getAsInt());
                continue;
            }
            if (type == Type.DIMENSION_TYPE) {
                if (!jsonObject.has(key.name())) continue;
                JsonElement jsonElement2 = jsonObject.get(key.name());
                map.setNonnull(key, ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)jsonElement2.getAsString())));
                continue;
            }
            if (type != Type.JSON || !jsonObject.has(key.name())) continue;
            el = jsonObject.get(key.name());
            if (el.isJsonObject()) {
                JsonObject obj = el.getAsJsonObject();
                map.setNonnull(key, obj.toString());
                continue;
            }
            if (!el.isJsonPrimitive()) continue;
            prim = el.getAsJsonPrimitive();
            if (prim.isString()) {
                map.setNonnull(key, prim.getAsString());
                continue;
            }
            if (!prim.isNumber()) {
                throw new RuntimeException("Bad type for key '" + key.name() + "'!");
            }
            map.setNonnull(key, "" + prim.getAsInt());
        }
        return map;
    }
}

