/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dnejei.compat;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import com.cmdpro.datanessence.recipe.ShapelessFabricationRecipe;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import com.google.common.collect.Lists;
import cy.jdkdigital.dnejei.compat.EssenceIngredient;
import cy.jdkdigital.dnejei.compat.EssenceWidget;
import cy.jdkdigital.dnejei.compat.Jei;
import cy.jdkdigital.dnejei.compat.UnlockableRecipeCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;

public class FabricationRecipeCategory
extends UnlockableRecipeCategory<RecipeHolder<IFabricationRecipe>> {
    private final IDrawable background;
    private final IDrawable shapeless;

    public FabricationRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, Jei.FABRICATION.get(), (Component)Component.translatable((String)"jei.dnejei.fabrication"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)BlockRegistry.FABRICATOR.get()).asItem().getDefaultInstance()), 123, 60);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"datanessence", (String)"textures/gui/data_tablet_crafting.png"), 10, 196, 123, 60).setTextureSize(256, 256).build();
        this.shapeless = guiHelper.drawableBuilder(DataTabletScreen.TEXTURE_CRAFTING, 242, 185, 14, 11).setTextureSize(256, 256).build();
    }

    @Override
    boolean isUnlocked(RecipeHolder<IFabricationRecipe> recipe) {
        return ((IFabricationRecipe)recipe.value()).getEntry() == null || this.hasData((IHasRequiredKnowledge)recipe.value());
    }

    @Override
    public void drawUnlocked(RecipeHolder<IFabricationRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (recipe.value() instanceof ShapelessFabricationRecipe) {
            this.shapeless.draw(guiGraphics, 93, 4);
        }
    }

    @Override
    public void setUnlockedRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IFabricationRecipe> recipe, IFocusGroup focuses) {
        boolean isShapeless = recipe.value() instanceof ShapelessFabricationRecipe;
        List<Ingredient> inputs = FabricationRecipeCategory.getIngredients((IFabricationRecipe)recipe.value(), isShapeless);
        int sOff = 0;
        if (!isShapeless) {
            if (this.canFit(inputs, 1, 3)) {
                --sOff;
            }
            if (this.canFit(inputs, 3, 1)) {
                sOff -= 3;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int s = i + sOff;
            if (s >= 0 && s < inputs.size()) {
                builder.addSlot(RecipeIngredientRole.INPUT, i % 3 * 17 + 21, i / 3 * 17 + 5).addIngredients(inputs.get(s));
                continue;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, i % 3 * 17 + 21, i / 3 * 17 + 5).addIngredients(Ingredient.EMPTY);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 22).addItemStack(((IFabricationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    @Override
    public void setLockedRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IFabricationRecipe> recipe, IFocusGroup focuses) {
        ((IFabricationRecipe)recipe.value()).getIngredients().forEach(ingredient -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(ingredient));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(((IFabricationRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    @Override
    public void addUnlockedWidgets(IRecipeExtrasBuilder builder, RecipeHolder<IFabricationRecipe> recipe, IFocusGroup focuses) {
        HashMap<EssenceType, Float> essenceCost = new HashMap<EssenceType, Float>();
        for (Map.Entry i : ((IFabricationRecipe)recipe.value()).getEssenceCost().entrySet()) {
            essenceCost.put((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get((ResourceLocation)i.getKey()), (Float)i.getValue());
        }
        builder.addWidget((IRecipeWidget)new EssenceWidget(5, 6, new EssenceIngredient((EssenceType)EssenceTypeRegistry.ESSENCE.get(), essenceCost.getOrDefault(EssenceTypeRegistry.ESSENCE.get(), Float.valueOf(0.0f)).floatValue())));
        builder.addWidget((IRecipeWidget)new EssenceWidget(13, 6, new EssenceIngredient((EssenceType)EssenceTypeRegistry.LUNAR_ESSENCE.get(), essenceCost.getOrDefault(EssenceTypeRegistry.LUNAR_ESSENCE.get(), Float.valueOf(0.0f)).floatValue())));
        builder.addWidget((IRecipeWidget)new EssenceWidget(5, 32, new EssenceIngredient((EssenceType)EssenceTypeRegistry.NATURAL_ESSENCE.get(), essenceCost.getOrDefault(EssenceTypeRegistry.NATURAL_ESSENCE.get(), Float.valueOf(0.0f)).floatValue())));
        builder.addWidget((IRecipeWidget)new EssenceWidget(13, 32, new EssenceIngredient((EssenceType)EssenceTypeRegistry.EXOTIC_ESSENCE.get(), essenceCost.getOrDefault(EssenceTypeRegistry.EXOTIC_ESSENCE.get(), Float.valueOf(0.0f)).floatValue())));
    }

    private static List<Ingredient> getIngredients(IFabricationRecipe recipe, boolean isShapeless) {
        Object input;
        if (isShapeless) {
            input = recipe.getIngredients();
        } else {
            int width = recipe.canCraftInDimensions(2, 3) ? (recipe.canCraftInDimensions(1, 3) ? 1 : 2) : 3;
            input = Lists.newArrayList();
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                input.add((Ingredient)recipe.getIngredients().get(i));
                if ((i + 1) % width != 0) continue;
                for (int j = width; j < 3; ++j) {
                    input.add(Ingredient.EMPTY);
                }
            }
        }
        return input;
    }

    private boolean canFit(List<Ingredient> inputs, int width, int height) {
        if (inputs.size() > 9) {
            return false;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            int x = i % 3;
            int y = i / 3;
            if (inputs.get(i).isEmpty() || x < width && y < height) continue;
            return false;
        }
        return true;
    }
}

