/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public abstract class CommonEnvironmentalAccumulatorRecipeJEI<T extends CommonEnvironmentalAccumulatorRecipeJEI<T>>
extends RecipeRegistryJeiRecipeWrapper<RecipeEnvironmentalAccumulator.Inventory, RecipeEnvironmentalAccumulator, T> {
    private final WeatherType inputWeather;
    private final WeatherType outputWeather;
    private final List<ItemStack> inputItems;
    private final ItemStack outputItem;
    private final int duration;
    private final int cooldownTime;
    private final float processingSpeed;

    public CommonEnvironmentalAccumulatorRecipeJEI(RecipeEnvironmentalAccumulator recipe) {
        super((RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get(), (Recipe)recipe);
        this.inputItems = Arrays.stream(recipe.getInputIngredient().getItems()).collect(Collectors.toList());
        this.inputWeather = recipe.getInputWeather();
        this.outputItem = recipe.getOutputItemFirst();
        this.outputWeather = recipe.getOutputWeather();
        this.duration = recipe.getDuration();
        this.cooldownTime = recipe.getCooldownTime();
        this.processingSpeed = recipe.getProcessingSpeed();
    }

    protected CommonEnvironmentalAccumulatorRecipeJEI() {
        super((RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get(), null);
        this.inputWeather = null;
        this.outputWeather = null;
        this.inputItems = null;
        this.outputItem = null;
        this.duration = 0;
        this.cooldownTime = 0;
        this.processingSpeed = 0.0f;
    }

    public WeatherType getInputWeather() {
        return this.inputWeather;
    }

    public WeatherType getOutputWeather() {
        return this.outputWeather;
    }

    public List<ItemStack> getInputItems() {
        return this.inputItems;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public float getProcessingSpeed() {
        return this.processingSpeed;
    }

    protected RecipeType<RecipeEnvironmentalAccumulator> getRecipeType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get();
    }
}

