/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemCondensedBloodConfig
extends ItemConfig {
    public ItemCondensedBloodConfig() {
        super((ModBase)EvilCraft._instance, "condensed_blood", eConfig -> new Item(new Item.Properties()));
        EvilCraft._instance.getModEventBus().addListener(this::registerCapability);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new FluidWrapper((ItemStack)stack), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    public static class FluidWrapper
    extends FluidBucketWrapper {
        public FluidWrapper(ItemStack container) {
            super(container);
        }

        protected int getVolume() {
            return 500;
        }

        public FluidStack getFluid() {
            return new FluidStack(RegistryEntries.FLUID_BLOOD, this.getVolume());
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            if (fluidStack == null) {
                this.container = this.container.copy();
                this.container.shrink(1);
            }
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getAmount() < this.getVolume()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty() && FluidStack.matches((FluidStack)fluidStack, (FluidStack)resource)) {
                if (action.execute()) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain < this.getVolume()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }
    }
}

