/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.item.ItemBurningGemStoneConfig;

public class ItemBurningGemStone
extends Item {
    public ItemBurningGemStone(Item.Properties properties) {
        super(properties);
    }

    public int getMaxDamage(ItemStack stack) {
        return ItemBurningGemStoneConfig.maxDamage;
    }

    public static boolean damageForPlayer(Player player, int swarmTier, boolean simulate) {
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            Pair current = it.nextIndexed();
            ItemStack itemStack = (ItemStack)current.getRight();
            if (itemStack.isEmpty() || itemStack.getItem() != RegistryEntries.ITEM_BURNING_GEM_STONE.get()) continue;
            if (!simulate) {
                itemStack.hurtAndBreak(1 + swarmTier, (ServerLevel)player.level(), (LivingEntity)player, i -> {
                    player.getInventory().setItem(((Integer)current.getLeft()).intValue(), ItemStack.EMPTY);
                    NeoForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, itemStack, null));
                });
                player.causeFoodExhaustion(10.0f);
            }
            return true;
        }
        return false;
    }
}

