/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ItemBucketEternalWater
extends BucketItem {
    public ItemBucketEternalWater(Item.Properties properties) {
        super((Fluid)Fluids.WATER, properties);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        BlockPos pos;
        BlockState blockState;
        ItemStack itemStack = player.getItemInHand(hand).copy();
        BlockHitResult position = ItemBucketEternalWater.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (position != null && position.getType() == HitResult.Type.BLOCK && (blockState = world.getBlockState(pos = BlockPos.containing((Position)position.getLocation()))).getBlock() == Blocks.WATER && (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) == 0) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        InteractionResultHolder result = super.use(world, player, hand);
        if (!((ItemStack)result.getObject()).isEmpty() && ((ItemStack)result.getObject()).getItem() == Items.BUCKET) {
            player.setItemInHand(hand, itemStack);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return result;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IFluidHandler handler = BlockEntityHelpers.getCapability((ILevelExtension)context.getLevel(), (BlockPos)context.getClickedPos(), (Object)context.getClickedFace(), (BlockCapability)Capabilities.FluidHandler.BLOCK).orElse(null);
        if (handler != null && !context.getLevel().isClientSide()) {
            handler.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (!(context.getPlayer().isCrouching() || block != Blocks.WATER_CAULDRON && block != Blocks.CAULDRON)) {
            if (!(context.getLevel().isClientSide() || block != Blocks.CAULDRON && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) >= 3)) {
                context.getPlayer().awardStat(Stats.USE_CAULDRON);
                context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
                context.getLevel().playSound(null, context.getClickedPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

