/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.inventory.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.inventory.NBTCraftingGrid;
import org.cyclops.evilcraft.item.ItemExaltedCrafter;
import org.cyclops.evilcraft.item.ItemExaltedCrafterConfig;

public class ContainerExaltedCrafter
extends ItemInventoryContainer<ItemExaltedCrafter> {
    private static final int GRID_OFFSET_X = 30;
    private static final int GRID_OFFSET_Y = 17;
    private static final int GRID_ROWS = 3;
    private static final int GRID_COLUMNS = 3;
    private static final int CHEST_INVENTORY_OFFSET_X = 8;
    private static final int CHEST_INVENTORY_OFFSET_Y = 84;
    private static final int CHEST_INVENTORY_ROWS = 3;
    private static final int CHEST_INVENTORY_COLUMNS = 9;
    private static final int INVENTORY_OFFSET_X = 8;
    private static final int INVENTORY_OFFSET_Y = 143;
    public static final String BUTTON_CLEAR = "clear";
    public static final String BUTTON_BALANCE = "balance";
    public static final String BUTTON_TOGGLERETURN = "toggleReturn";
    private final Level world = this.player.level();
    private final NBTCraftingGrid craftingGrid;
    private final ResultContainer result = new ResultContainer();
    private boolean initialized = false;

    public ContainerExaltedCrafter(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerExaltedCrafter(int id, Inventory inventory, ItemLocation itemLocation) {
        super((MenuType)RegistryEntries.CONTAINER_EXALTED_CRAFTER.get(), id, inventory, itemLocation);
        this.craftingGrid = new NBTCraftingGrid(this.player, itemLocation, (AbstractContainerMenu)this);
        this.addCraftingGrid(this.player, this.craftingGrid);
        this.addInventory(((ItemExaltedCrafter)this.getItem()).getSupplementaryInventory(this.player, itemLocation), 0, 8, 84, 3, 9);
        this.addPlayerInventory(this.player.getInventory(), 8, 143);
        this.initialized = true;
        this.slotsChanged((Container)this.craftingGrid);
        this.putButtonAction(BUTTON_CLEAR, (buttonId, container) -> this.clearGrid());
        this.putButtonAction(BUTTON_BALANCE, (buttonId, container) -> this.balanceGrid());
        this.putButtonAction(BUTTON_TOGGLERETURN, (buttonId, container) -> ((ContainerExaltedCrafter)container).setReturnToInnerInventory(!((ContainerExaltedCrafter)container).isReturnToInnerInventory()));
    }

    public void clearGrid() {
        for (int i = 0; i < this.craftingGrid.getContainerSize(); ++i) {
            this.quickMoveStack(this.player, i);
        }
    }

    public void balanceGrid() {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)this.craftingGrid.getContainerSize());
        for (int slot = 0; slot < this.craftingGrid.getContainerSize(); ++slot) {
            ItemStack itemStack = this.craftingGrid.getItem(slot);
            if (itemStack.isEmpty()) continue;
            int amount = itemStack.getCount();
            itemStack = itemStack.copy();
            itemStack.setCount(1);
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).copy();
                original.setCount(1);
                if (!ItemStack.matches((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).grow(amount);
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.setCount(amount);
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).getCount() / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).getCount() % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).copy();
                itemStack.setCount(((Integer)slot.getRight()).intValue());
                this.craftingGrid.setItem((Integer)slot.getKey(), itemStack);
            }
        }
    }

    public boolean isReturnToInnerInventory() {
        ItemStack itemStack = this.getItemStack(this.player);
        return !itemStack.isEmpty() && ItemExaltedCrafter.isReturnToInner(itemStack);
    }

    protected void setReturnToInnerInventory(boolean returnToInner) {
        ItemStack itemStack = this.getItemStack(this.player);
        if (!itemStack.isEmpty()) {
            ItemExaltedCrafter.setReturnToInner(itemStack, returnToInner);
        }
    }

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        if (!reverse && !ItemExaltedCrafterConfig.shiftCraftingGrid) {
            return 10;
        }
        if (reverse && originSlot < 10) {
            if (this.isReturnToInnerInventory()) {
                return 10;
            }
            return slotStart;
        }
        return super.getSlotStart(originSlot, slotStart, reverse);
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        if (this.isReturnToInnerInventory() && reverse && originSlot < 10) {
            return this.getSizeInventory();
        }
        return slotRange;
    }

    protected void addCraftingGrid(Player player, NBTCraftingGrid grid) {
        this.addInventory((Container)grid, 0, 30, 17, 3, 3);
        this.addSlot((Slot)new ResultSlot(player, (CraftingContainer)grid, (Container)this.result, 0, 124, 35));
    }

    protected int getSizeInventory() {
        return 37;
    }

    public void slotsChanged(Container inventory) {
        if (this.initialized && !this.world.isClientSide()) {
            ItemStack itemstack = ItemStack.EMPTY;
            RecipeHolder irecipe = this.world.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftingGrid.asCraftInput(), this.world).orElse(null);
            if (irecipe != null && this.result.setRecipeUsed(this.world, (ServerPlayer)this.player, irecipe)) {
                itemstack = ((CraftingRecipe)irecipe.value()).assemble((RecipeInput)this.craftingGrid.asCraftInput(), (HolderLookup.Provider)this.world.registryAccess());
            }
            this.result.setItem(0, itemstack);
            ((ServerPlayer)this.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.getStateId(), 9, itemstack));
            this.craftingGrid.save();
        }
    }
}

