/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.component.DataComponentBiomeConfig;

@GameTestHolder(value="evilcraft")
@PrefixGameTestTemplate(value=false)
public class GameTestsBiomeExtract {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=150)
    public void testBiomeExtractThrow(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getBottomCenter());
        player.setXRot(90.0f);
        ItemStack biomeExtract = new ItemStack(RegistryEntries.ITEM_BIOME_EXTRACT);
        biomeExtract.set(RegistryEntries.COMPONENT_BIOME, (Object)new DataComponentBiomeConfig.BiomeHolder(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"beach"), (HolderGetter<Biome>)helper.getLevel().holderLookup(Registries.BIOME)));
        player.setItemInHand(InteractionHand.MAIN_HAND, biomeExtract);
        player.getItemInHand(InteractionHand.MAIN_HAND).use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.succeedWhen(() -> helper.assertValueEqual((Object)helper.getLevel().getBiome(helper.absolutePos(POS)).getRegisteredName(), (Object)"minecraft:beach", "Biome was not changed"));
    }
}

