/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.RenderVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityVengeanceSpiritConfig
extends EntityConfig<EntityVengeanceSpirit> {
    @ConfigurableProperty(category="mob", comment="The maximum amount of vengeance spirits naturally spawnable in the spawnLimitArea.")
    public static int spawnLimit = 5;
    @ConfigurableProperty(category="mob", comment="The area in which the spawn limit will be checked on each spawn attempt.")
    public static int spawnLimitArea = 32;
    @ConfigurableProperty(category="mob", comment="The blacklisted entity spirits, by entity name. Regular expressions are allowed.")
    public static List<String> entityBlacklist = Lists.newArrayList((Object[])new String[]{"evilcraft:vengeance_spirit", "evilcraft:controlled_zombie", "evilcraft:werewolf", "minecraft:ender_dragon", "farmingforblockheads:merchant"});
    @ConfigurableProperty(category="mob", comment="Whether vengeance spirits should always be visible in creative mode.")
    public static boolean alwaysVisibleInCreative = false;
    @ConfigurableProperty(category="mob", comment="The 1/X chance that an actual spirit will spawn when doing actions like mining with the Vengeance Pickaxe.")
    public static int nonDegradedSpawnChance = 5;

    public EntityVengeanceSpiritConfig() {
        super((ModBase)EvilCraft._instance, "vengeance_spirit", eConfig -> EntityType.Builder.of(EntityVengeanceSpirit::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.0f).fireImmune(), EntityVengeanceSpiritConfig.getDefaultSpawnEggItemConfigConstructor((ModBase)EvilCraft._instance, (String)"vengeance_spirit_spawn_egg", (int)Helpers.RGBToInt((int)64, (int)16, (int)93), (int)Helpers.RGBToInt((int)134, (int)60, (int)169)));
        EvilCraft._instance.getModEventBus().addListener(this::onEntityAttributeCreationEvent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityVengeanceSpirit> getRender(EntityRendererProvider.Context renderContext, ItemRenderer itemRenderer) {
        return new RenderVengeanceSpirit(renderContext, this);
    }

    public void onRegistered() {
        super.onRegistered();
        EvilCraft._instance.getImcHandler().registerAction("blacklist_vengeance_spirit", message -> {
            Object value = message.getMessageSupplier().get();
            if (value instanceof String) {
                EntityVengeanceSpirit.addToBlacklistIMC((String)value);
                return true;
            }
            return false;
        });
        NeoForge.EVENT_BUS.register(EntityVengeanceSpirit.class);
    }

    public void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)this.getInstance(), Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3125).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.STEP_HEIGHT, 5.0).build());
    }
}

