/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelleConfig;

public class EntityPoisonousLibelle
extends FlyingMob
implements Enemy {
    private static final int POISON_DURATION = 2;
    public double targetX;
    public double targetY;
    public double targetZ;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    private Entity target;
    private static int WINGLENGTH;
    private int wingProgress = 0;
    private boolean wingGoUp = true;
    private static final int MAXHEIGHT = 80;
    private float randomYawVelocity;

    public EntityPoisonousLibelle(EntityType<? extends EntityPoisonousLibelle> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.xpReward = 10;
    }

    public EntityPoisonousLibelle(Level world) {
        this((EntityType<? extends EntityPoisonousLibelle>)((EntityType)RegistryEntries.ENTITY_POISONOUS_LIBELLE.get()), world);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void checkLibelleSpawn(FinalizeSpawnEvent event) {
        if (event.getEntity() instanceof EntityPoisonousLibelle && event.getEntity().getY() < (double)EntityPoisonousLibelleConfig.minY) {
            event.setSpawnCancelled(true);
        }
    }

    public SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.BAT_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    public boolean isPushable() {
        return false;
    }

    public void aiStep() {
        float f;
        super.aiStep();
        if (this.level().isClientSide()) {
            f = Mth.cos((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = Mth.cos((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.random.nextInt(45) == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BAT_AMBIENT, SoundSource.AMBIENT, 0.1f, 0.8f + this.random.nextFloat() * 0.3f);
            }
        }
        this.prevAnimTime = this.animTime;
        Vec3 m = this.getDeltaMovement();
        f = 0.2f / (Mth.sqrt((float)((float)(m.x * m.x + m.z * m.z))) * 10.0f + 1.0f);
        this.animTime += (f *= (float)Math.pow(2.0, m.y));
        if (this.level().isClientSide()) {
            if (this.lerpSteps > 0) {
                double distanceX = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
                double distanceY = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
                double distanceZ = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
                double distance = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
                this.setYRot((float)((double)this.getYRot() + distance / (double)this.lerpSteps));
                this.setXRot((float)((double)this.getXRot() + (this.targetX - (double)this.getXRot()) / (double)this.lerpSteps));
                --this.lerpSteps;
                this.setPos(distanceX, distanceY, distanceZ);
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            float limitDistanceY;
            double distanceX = this.targetX - this.getX();
            double distanceY = this.targetY - this.getY();
            double distanceZ = this.targetZ - this.getZ();
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (this.target != null) {
                double distancedZ;
                this.targetX = this.target.getX();
                this.targetZ = this.target.getZ();
                double distancedX = this.targetX - this.getX();
                double distancedHeightPlane = Math.sqrt(distancedX * distancedX + (distancedZ = this.targetZ - this.getZ()) * distancedZ);
                double Yplus = 0.4 + distancedHeightPlane / 80.0 - 1.0;
                if (Yplus > 10.0) {
                    Yplus = 10.0;
                }
                this.targetY = Math.min(this.target.getBoundingBox().minY + Yplus, 80.0);
            } else {
                this.targetX += (this.random.nextDouble() * 2.0 - 1.0) * 2.0;
                this.targetZ += (this.random.nextDouble() * 2.0 - 1.0) * 2.0;
            }
            if (this.forceNewTarget || distance < 3.0 || distance > 250.0 || this.horizontalCollision || this.verticalCollision || this.targetY > 80.0) {
                this.setNewTarget();
            }
            if ((distanceY /= (double)Mth.sqrt((float)((float)(distanceX * distanceX + distanceZ * distanceZ)))) < (double)(-(limitDistanceY = 0.6f))) {
                distanceY = -limitDistanceY;
            }
            if (distanceY > (double)limitDistanceY) {
                distanceY = limitDistanceY;
            }
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, distanceY * 0.1, 0.0));
            this.setYRot(Mth.wrapDegrees((float)this.getYRot()));
            double newYaw = 180.0 - Math.atan2(distanceX, distanceZ) * 180.0 / Math.PI;
            double differenceYaw = Mth.wrapDegrees((double)(newYaw - (double)this.getYRot()));
            double limitDifferenceYaw = 50.0;
            if (differenceYaw > limitDifferenceYaw) {
                differenceYaw = limitDifferenceYaw;
            }
            if (differenceYaw < -limitDifferenceYaw) {
                differenceYaw = -limitDifferenceYaw;
            }
            Vec3 distanceVector = new Vec3(this.targetX - this.getX(), this.targetY - this.getY(), this.targetZ - this.getZ()).normalize();
            Vec3 rotationVector = new Vec3((double)Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)), m.y, (double)(-Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)))).normalize();
            float dynamicMotionMultiplier = (float)(rotationVector.dot(distanceVector) + 0.5) / 1.5f;
            if (dynamicMotionMultiplier < 0.0f) {
                dynamicMotionMultiplier = 0.0f;
            }
            this.randomYawVelocity *= 0.8f;
            float motionDistanceHeightPlaneFloat = Mth.sqrt((float)((float)(m.x * m.x + m.z * m.z))) * 1.0f + 1.0f;
            double motionDistanceHeightPlane = Math.sqrt(m.x * m.x + m.z * m.z) * 1.0 + 1.0;
            if (motionDistanceHeightPlane > 40.0) {
                motionDistanceHeightPlane = 40.0;
            }
            this.randomYawVelocity = (float)((double)this.randomYawVelocity + differenceYaw * (0.7 / motionDistanceHeightPlane / (double)motionDistanceHeightPlaneFloat));
            this.setYRot(this.getYRot() + this.randomYawVelocity * 0.1f);
            float scaledMotionDistanceHeightPlane = (float)(2.0 / (motionDistanceHeightPlane + 1.0));
            float staticMotionMultiplier = 0.03f;
            this.moveRelative(staticMotionMultiplier * (dynamicMotionMultiplier * scaledMotionDistanceHeightPlane + (1.0f - scaledMotionDistanceHeightPlane)), new Vec3(0.0, 0.0, -1.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 vec3d3 = this.getDeltaMovement().normalize();
            double d6 = 0.8 + 0.15 * (vec3d3.dot(rotationVector) + 1.0) / 2.0;
            this.setDeltaMovement(this.getDeltaMovement().multiply(d6, (double)0.91f, d6));
        }
        this.yBodyRot = this.getYRot();
        if (!this.level().isClientSide() && this.hurtTime == 0 && this.isAlive()) {
            this.attackEntitiesInList(this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0, 0.0, 1.0)));
        }
        if (this.wingGoUp) {
            ++this.wingProgress;
            if (this.wingProgress > WINGLENGTH) {
                this.wingGoUp = false;
            }
        } else {
            --this.wingProgress;
            if (this.wingProgress < -WINGLENGTH) {
                this.wingGoUp = true;
            }
        }
        if (!this.level().isClientSide() && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        int chance = EntityPoisonousLibelleConfig.poisonChance;
        for (Entity entity : entities) {
            if (chance <= 0 || this.level().random.nextInt(chance) != 0 || !(entity instanceof LivingEntity)) continue;
            boolean shouldAttack = true;
            if (entity instanceof Player && ((Player)entity).isCreative()) {
                shouldAttack = false;
                this.setNewTarget();
            }
            if (!shouldAttack) continue;
            if (EntityPoisonousLibelleConfig.hasAttackDamage) {
                entity.hurt(this.level().damageSources().mobAttack((LivingEntity)this), 0.5f);
            }
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, 40, 1));
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        boolean targetSet = false;
        if (this.random.nextInt(2) == 0 && !this.level().players().isEmpty() && !this.level().isDay()) {
            this.target = (Entity)this.level().players().get(this.random.nextInt(this.level().players().size()));
            targetSet = true;
            if (this.target instanceof Player && ((Player)this.target).isCreative()) {
                targetSet = false;
            }
        }
        if (!targetSet) {
            double d2;
            double d1;
            double d0;
            boolean flag;
            do {
                this.targetX = this.getX();
                this.targetY = 80.0f - this.random.nextFloat() * 30.0f;
                this.targetZ = this.getZ();
                this.targetX += (double)(this.random.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.random.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.getX() - this.targetX) * d0 + (d1 = this.getY() - this.targetY) * d1 + (d2 = this.getZ() - this.targetZ) * d2 > 20.0));
            this.target = null;
        }
    }

    public float getWingProgressScaled(float scale) {
        return (float)this.wingProgress / (float)WINGLENGTH * scale;
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends EntityPoisonousLibelle> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && EntityPoisonousLibelle.checkMobSpawnRules(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    static {
        NeoForge.EVENT_BUS.register(EntityPoisonousLibelle.class);
        WINGLENGTH = 4;
    }
}

