/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConverter;

public class ImplicitFluidConversionTank
extends SingleUseTank {
    private ImplicitFluidConverter converter;

    public ImplicitFluidConversionTank(int capacity, ImplicitFluidConverter converter) {
        super(capacity);
        this.converter = converter;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack converted = this.converter.convert(resource);
        if (converted.isEmpty()) {
            return 0;
        }
        double ratio = !resource.isEmpty() ? this.converter.getRatio(resource.getFluid()) : 1.0;
        return (int)Math.ceil((double)super.fill(converted, action) / ratio);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        return super.drain(resource, action);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid.isEmpty() || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return fluid.isEmpty() || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid());
    }
}

