/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class SoundDegradation
extends StochasticDegradationEffect {
    private static final double CHANCE = 0.1;

    public SoundDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        RandomSource random = degradable.getDegradationWorld().random;
        Level world = degradable.getDegradationWorld();
        for (Entity entity : degradable.getAreaEntities()) {
            if (!(entity instanceof Player)) continue;
            world.playSound((Player)entity, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.BLAZE_AMBIENT, SoundSource.AMBIENT, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            world.playSound((Player)entity, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENDER_DRAGON_FLAP, SoundSource.AMBIENT, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        }
    }
}

