/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritPortal;
import org.joml.Matrix4f;

public class RenderBlockEntitySpiritPortal
implements BlockEntityRenderer<BlockEntitySpiritPortal> {
    private static final ResourceLocation PORTALBASE = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/model/portal_bases.png");

    public RenderBlockEntitySpiritPortal(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(BlockEntitySpiritPortal blockEntity) {
        return AABB.INFINITE;
    }

    public void render(BlockEntitySpiritPortal tileentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float progress = tileentity.getProgress();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 0.5f, 0.5f);
        this.renderPortalBase(matrixStackIn, bufferIn, progress);
        Random random = new Random();
        long seed = tileentity.getBlockPos().asLong();
        random.setSeed(seed);
        this.renderStar(matrixStackIn, bufferIn, seed, progress, Tesselator.getInstance(), partialTicks, random);
        matrixStackIn.popPose();
    }

    private void renderStar(PoseStack matrixStackIn, MultiBufferSource bufferIn, float rotation, float progress, Tesselator tessellator, float partialTicks, Random random) {
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(rotation * -0.2f % 360.0f / 2.0f));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation * -0.2f % 360.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(rotation * -0.2f % 360.0f / 2.0f));
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 7.0f;
        float MAX_OPACITY = 40.0f;
        float f2 = 0.0f;
        if (progress > 0.8f) {
            f2 = (progress - 0.8f) / 0.2f;
        }
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + progress * 90.0f));
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            VertexConsumer vb = bufferIn.getBuffer(RenderType.lightning());
            Matrix4f matrix = matrixStackIn.last().pose();
            vb.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(171, 97, 210, (int)(MAX_OPACITY * (1.0f - f2)));
            vb.addVertex(matrix, -0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
            vb.addVertex(matrix, 0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
            vb.addVertex(matrix, 0.0f, f3, 1.0f * f4).setColor(175, 100, 215, 0);
            vb.addVertex(matrix, -0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
            ++i;
        }
    }

    private void renderPortalBase(PoseStack matrixStackIn, MultiBufferSource bufferIn, float progress) {
        matrixStackIn.pushPose();
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        matrixStackIn.mulPose(renderManager.cameraOrientation());
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        this.renderIconForProgress(matrixStackIn, bufferIn, (int)(progress * 100.0f) % 4, progress);
        matrixStackIn.popPose();
    }

    private void renderIconForProgress(PoseStack matrixStackIn, MultiBufferSource bufferIn, int index, float progress) {
        if (progress > 0.8f) {
            progress -= (progress - 0.8f) * 4.0f;
        }
        float u1 = 0.0625f * (float)index;
        float u2 = 0.0625f * (float)(index + 1);
        float v1 = 0.0f;
        float v2 = 0.0625f;
        matrixStackIn.pushPose();
        matrixStackIn.scale(0.5f * progress, 0.5f * progress, 0.5f * progress);
        matrixStackIn.translate(-0.5f, -0.5f, 0.0f);
        int j = 150;
        int k = 150;
        VertexConsumer vb = bufferIn.getBuffer(RenderType.text((ResourceLocation)PORTALBASE));
        Matrix4f matrix = matrixStackIn.last().pose();
        vb.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(0.72f, 0.5f, 0.23f, 0.9f).setUv(u1, v2).setUv2(j, k);
        vb.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u1, v1).setUv2(j, k);
        vb.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u2, v1).setUv2(j, k);
        vb.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u2, v2).setUv2(j, k);
        matrixStackIn.popPose();
    }
}

