/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityBeacon;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class RenderBlockEntityEnvironmentalAccumulator
extends RenderBlockEntityBeacon<BlockEntityEnvironmentalAccumulator> {
    private static final int ITEM_SPIN_SPEED = 3;

    public RenderBlockEntityEnvironmentalAccumulator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderBeacon(BlockEntityEnvironmentalAccumulator tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getMovingItemY() != -1.0f) {
            matrixStack.pushPose();
            matrixStack.translate(-0.5f, -0.5f + tile.getMovingItemY(), -0.5f);
            this.renderProcessingItem(matrixStack, bufferIn, tile.getRecipe(), tile.getDegradationWorld(), partialTicks);
            matrixStack.popPose();
        }
        super.renderBeacon(tile, partialTicks, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected boolean isInnerBeam(BlockEntityEnvironmentalAccumulator tile) {
        return tile.getMovingItemY() >= 0.0f;
    }

    private void renderProcessingItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, RecipeHolder<RecipeEnvironmentalAccumulator> recipe, Level world, float partialTickTime) {
        if (recipe == null) {
            return;
        }
        ItemStack stack = ((RecipeEnvironmentalAccumulator)recipe.value()).getInputIngredient().getItems()[0];
        if (stack.isEmpty()) {
            return;
        }
        double totalTickTime = (float)world.getGameTime() + partialTickTime;
        float angle = (float)(3.0 * (totalTickTime % 360.0));
        if (stack.getItem() instanceof BlockItem) {
            matrixStackIn.translate(1.0f, 0.675f, 1.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(angle));
        } else {
            matrixStackIn.translate(1.0f, 1.0f, 1.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(angle));
        }
        matrixStackIn.scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, world, 0);
    }
}

