/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;
import org.joml.Vector3f;

public class RenderBlockEntityDisplayStand
implements BlockEntityRenderer<BlockEntityDisplayStand> {
    private static final Map<Direction, Vector3f> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Direction.SOUTH, (Object)new Vector3f(90.0f, 0.0f, 0.0f)).put((Object)Direction.WEST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.EAST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.UP, (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Direction.DOWN, (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();

    public RenderBlockEntityDisplayStand(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDisplayStand tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getInventory().getItem(0).isEmpty()) {
            BlockState blockState = tile.getLevel().getBlockState(tile.getBlockPos());
            this.renderItem(matrixStackIn, bufferIn, tile.getInventory().getItem(0), (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH), (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.AXIS_X, (Comparable)Boolean.valueOf(true)), tile.getDirection() == Direction.AxisDirection.POSITIVE, tile.getLevel());
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, Direction facing, boolean axisX, boolean positiveDirection, Level level) {
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        if (itemStack.getItem() instanceof BlockItem) {
            matrixStack.scale(0.6f, 0.6f, 0.6f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else if (itemStack.getItem() instanceof IBroom) {
            matrixStack.scale(2.0f, 2.0f, 2.0f);
        } else if (!(itemStack.getItem() instanceof IBroom)) {
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.translate(0.0f, 0.25f, 0.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        Vector3f vec = ROTATIONS.get(facing);
        matrixStack.mulPose(Axis.XP.rotationDegrees(vec.x()));
        matrixStack.mulPose(Axis.YP.rotationDegrees(vec.y()));
        if (!axisX) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            if (!positiveDirection) {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        } else if (positiveDirection) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, renderTypeBuffer, level, 0);
        matrixStack.popPose();
    }
}

