/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityEternalWater;

public class BlockEternalWater
extends BlockWithEntity {
    public static final MapCodec<BlockEternalWater> CODEC = BlockEternalWater.simpleCodec(BlockEternalWater::new);

    public BlockEternalWater(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEternalWater::new);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockEternalWater.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ETERNAL_WATER.get()), (BlockEntityTicker)new BlockEntityEternalWater.TickerServer());
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        ItemStack itemStack = pPlayer.getInventory().getSelected();
        if (!itemStack.isEmpty()) {
            if (itemStack.getItem() == Items.BUCKET) {
                if (!pLevel.isClientSide()) {
                    itemStack.shrink(1);
                    if (itemStack.isEmpty()) {
                        pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)Items.WATER_BUCKET));
                    } else if (!pPlayer.getInventory().add(new ItemStack((ItemLike)Items.WATER_BUCKET))) {
                        pPlayer.drop(new ItemStack((ItemLike)Items.WATER_BUCKET), false);
                    }
                    pLevel.playSound(null, pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
            FluidUtil.getFluidHandler((ItemStack)itemStack).ifPresent(fluidHandler -> fluidHandler.fill(BlockEntityEternalWater.WATER, IFluidHandler.FluidAction.EXECUTE));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, worldIn, pos, newState, isMoving);
        if (!worldIn.isClientSide() && newState.getBlock() == Blocks.WATER) {
            worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
        }
    }

    public FluidState getFluidState(BlockState state) {
        return Fluids.WATER.defaultFluidState();
    }
}

