/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.item.ItemEntangledChalice;

public class BlockEntangledChalice
extends BlockWithEntity
implements IInformationProvider,
IBlockTank,
IBlockRarityProvider {
    public static final MapCodec<BlockEntangledChalice> CODEC = BlockEntangledChalice.simpleCodec(BlockEntangledChalice::new);
    public static final BooleanProperty DRAINING = BooleanProperty.create((String)"draining");
    public static final ModelProperty<String> TANK_ID = new ModelProperty();
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BlockEntangledChalice(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEntangledChalice::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DRAINING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockEntangledChalice.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENTANGLED_CHALICE.get()), (BlockEntityTicker)new BlockEntityEntangledChalice.TickerServer());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DRAINING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DRAINING, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (FluidUtil.interactWithFluidHandler((Player)pPlayer, (InteractionHand)pHand, (Level)pLevel, (BlockPos)pPos, (Direction)Direction.UP)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pLevel.isClientSide()) {
            String tankId = BlockEntityHelpers.get((BlockGetter)pLevel, (BlockPos)pPos, BlockEntityEntangledChalice.class).map(BlockEntityEntangledChalice::getWorldTankId).orElse("null");
            pPlayer.displayClientMessage((Component)Component.translatable((String)L10NHelpers.localize((String)"block.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)})), true);
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        return BlockTankHelpers.getInfoTank(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag iTooltipFlag) {
    }

    @Override
    public int getDefaultCapacity() {
        return 4000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.isCrouching()) {
            if (!world.isClientSide()) {
                ItemStack activated = itemStack.copy();
                ItemHelpers.toggleActivation(activated);
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Item.TooltipContext context) {
        return ItemHelpers.isActivated(itemStack);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos blockPos) {
        BlockEntityEntangledChalice tank;
        Fluid fluidType;
        BlockEntity tile = world.getBlockEntity(blockPos);
        if (tile != null && tile instanceof BlockEntityEntangledChalice && (fluidType = (tank = (BlockEntityEntangledChalice)tile).getTank().getFluidType()) != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)fluidType.getFluidType().getLightLevel());
        }
        return 0;
    }

    public void fillItemCategory(NonNullList<ItemStack> list) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        ItemEntangledChalice.FluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        fluidHandler.setTankID("creative");
        list.add((Object)itemStack);
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return Rarity.RARE;
    }
}

