/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;

public class BlockDarkTankConfig
extends BlockConfig {
    @ConfigurableProperty(category="machine", comment="The maximum tank size visible in the creative tabs. (Make sure that you do not cross the max int size.)")
    public static int maxTankCreativeSize = 4096000;
    @ConfigurableProperty(category="machine", comment="If creative versions for all fluids should be added to the creative tab.")
    public static boolean creativeTabFluids = true;
    @ConfigurableProperty(category="machine", comment="If the fluid should be rendered statically. Fluids won't be shown fluently, but more efficiently.", requiresMcRestart=true)
    public static boolean staticBlockRendering = false;
    @ConfigurableProperty(category="item", comment="If held buckets should be autofilled when enabled.", isCommandable=true)
    public static boolean autoFillBuckets = false;

    public BlockDarkTankConfig() {
        super((ModBase)EvilCraft._instance, "dark_tank", eConfig -> new BlockDarkTank(BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.GLASS)), (eConfig, block) -> new ItemBlockFluidContainer((Block)block, new Item.Properties()));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected Collection<ItemStack> defaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        ((BlockDarkTank)this.getInstance()).fillItemCategory((NonNullList<ItemStack>)list);
        return list;
    }
}

