/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class DistortTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codec.INT.optionalFieldOf("min_entities").forGetter(Instance::minEntities), (App)EntityPredicate.CODEC.optionalFieldOf("entity").forGetter(Instance::entityPredicate)).apply((Applicative)p_311401_, Instance::new));

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void test(ServerPlayer player, List<Entity> entities) {
        this.trigger(player, instance -> instance.test(player, entities));
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<Integer> minEntities, Optional<EntityPredicate> entityPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public boolean test(ServerPlayer player, List<Entity> entities) {
            int count = 0;
            for (Entity entity : entities) {
                if (!this.entityPredicate.map(p -> p.matches(player, entity)).orElse(true).booleanValue()) continue;
                ++count;
            }
            return count >= this.minEntities.orElse(0);
        }
    }
}

