/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WebWall
extends Feature<NoneFeatureConfiguration> {
    public static final Map<Direction.Axis, Set<Direction>> AXIS_TO_FACINGS = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.Axis.class), map -> {
        map.put(Direction.Axis.X, ImmutableSet.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.UP, (Object)Direction.DOWN));
        map.put(Direction.Axis.Z, ImmutableSet.of((Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.UP, (Object)Direction.DOWN));
        map.put(Direction.Axis.Y, ImmutableSet.of((Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.NORTH, (Object)Direction.SOUTH));
    })));

    public WebWall(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockPos = new ChunkPos(context.origin()).getMiddleBlockPosition(context.origin().getY());
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        if (bulkSectionAccess.getBlockState(blockPos).is(Blocks.CAVE_AIR)) {
            for (Direction.Axis axis : Direction.Axis.values()) {
                HashSet<BlockPos> validSpaces = new HashSet<BlockPos>();
                validSpaces.add(blockPos);
                boolean isInBounds = this.setIfValidSpace(bulkSectionAccess, axis, blockPos, blockPos, validSpaces);
                if (!isInBounds) continue;
                for (BlockPos validPos : validSpaces) {
                    for (int attempt = 0; attempt < 12; ++attempt) {
                        ((Feature)BzFeatures.STICKY_HONEY_RESIDUE_FEATURE.get()).place(new FeaturePlaceContext(context.topFeature(), context.level(), context.chunkGenerator(), context.random(), validPos.offset(context.random().nextInt(9) - 4, context.random().nextInt(9) - 4, context.random().nextInt(9) - 4), (FeatureConfiguration)((NoneFeatureConfiguration)context.config())));
                    }
                    BlockState state = bulkSectionAccess.getBlockState(validPos);
                    if (state.is((Block)BzBlocks.HONEY_WEB.get())) {
                        bulkSectionAccess.setBlockState(validPos, (BlockState)state.setValue((Property)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), false);
                        continue;
                    }
                    bulkSectionAccess.setBlockState(validPos, (BlockState)((Block)BzBlocks.HONEY_WEB.get()).defaultBlockState().setValue((Property)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean setIfValidSpace(UnsafeBulkSectionAccess bulkSectionAccess, Direction.Axis axis, BlockPos originPos, BlockPos currentPos, Set<BlockPos> validSpaces) {
        int maxDistance = 14;
        for (Direction direction : AXIS_TO_FACINGS.get(axis)) {
            BlockPos newBlockPos = currentPos.relative(direction);
            if (Math.abs(newBlockPos.getX() - originPos.getX()) > maxDistance || Math.abs(newBlockPos.getY() - originPos.getY()) > maxDistance || Math.abs(newBlockPos.getZ() - originPos.getZ()) > maxDistance) {
                return false;
            }
            if (validSpaces.contains(newBlockPos)) continue;
            BlockState state = bulkSectionAccess.getBlockState(newBlockPos);
            if (state.isAir() || state.is((Block)BzBlocks.PILE_OF_POLLEN.get()) || state.is((Block)BzBlocks.HONEY_WEB.get())) {
                validSpaces.add(newBlockPos);
                if (this.setIfValidSpace(bulkSectionAccess, axis, originPos, newBlockPos, validSpaces)) continue;
                return false;
            }
            if (!state.is((Block)BzBlocks.HONEY_WEB.get())) continue;
            validSpaces.add(newBlockPos);
        }
        return true;
    }
}

