/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CalmingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.calmingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.calmingEssenceAbilityUse;

    public CalmingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 44525;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_calming_description_1").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_calming_description_2").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_calming_description_3").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        if (((AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive()) {
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 12L == 0L) {
                CalmingEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom());
            }
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 20L == 0L) {
                serverPlayer.getStats().setValue((Player)serverPlayer, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 0);
                for (Entity entity : level.getEntities((Entity)serverPlayer, serverPlayer.getBoundingBox().inflate(60.0))) {
                    Warden warden;
                    NeutralMob neutralMob;
                    Mob mob;
                    if (entity.getType().is(BzTags.CALMING_ALLOW_ANGER_THROUGH)) continue;
                    if (entity instanceof Mob && (mob = (Mob)entity).getTarget() == serverPlayer) {
                        mob.setTarget(null);
                    }
                    if (entity instanceof NeutralMob && (neutralMob = (NeutralMob)entity).getPersistentAngerTarget() == serverPlayer.getUUID()) {
                        neutralMob.stopBeingAngry();
                    }
                    if (!(entity instanceof Warden) || (warden = (Warden)entity).getAngerManagement().getActiveEntity().orElse(null) != serverPlayer) continue;
                    warden.clearAnger((Entity)serverPlayer);
                }
                if (serverPlayer.removeEffect(BzEffects.WRATH_OF_THE_HIVE.holder())) {
                    this.decrementAbilityUseRemaining(itemStack, serverPlayer, this.getAbilityUseRemaining(itemStack));
                } else if (serverPlayer.isSprinting()) {
                    this.decrementAbilityUseRemaining(itemStack, serverPlayer, 60);
                } else {
                    this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1);
                }
            }
        }
    }

    private void depleteEssence(ItemStack stack, ServerPlayer serverPlayer) {
        this.setAbilityUseRemaining(stack, 0);
        this.setDepleted(stack, serverPlayer, false);
    }

    public static boolean IsCalmingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.getOffhandItem();
            return offHandItem.is((Item)BzItems.ESSENCE_CALMING.get()) && ((AbilityEssenceActivityData)offHandItem.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive();
        }
        return false;
    }

    public static void OnAttack(BzEntityHurtEvent event) {
        Entity entity;
        DamageSource damageSource = event.source();
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof Mob && (entity = damageSource.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            offHandItem = serverPlayer.getOffhandItem();
            Item item = offHandItem.getItem();
            if (item instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)item;
                if (CalmingEssence.IsCalmingEssenceActive((Player)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        } else if (livingEntity instanceof ServerPlayer) {
            Item item;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (damageSource.getEntity() instanceof Mob && (item = (offHandItem = serverPlayer.getOffhandItem()).getItem()) instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)item;
                if (CalmingEssence.IsCalmingEssenceActive((Player)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.SPARKLE_PARTICLE.get()), location.x(), location.y() + 1.0, location.z(), 1, random.nextGaussian() * 0.2, random.nextGaussian() * 0.25 + 0.1, random.nextGaussian() * 0.2, 0.0);
    }
}

