/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids.neoforge;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class BzFluidBottlesWrapper
implements IFluidHandlerItem {
    public static final int BOTTLE_VOLUME = 250;
    protected ItemStack container;
    protected Fluid fluid;

    public BzFluidBottlesWrapper(ItemStack container, Fluid fluid) {
        this.container = container;
        this.fluid = fluid;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return !fluid.getFluidType().getBucket(fluid).isEmpty();
    }

    public FluidStack getFluid() {
        return new FluidStack(this.fluid, 250);
    }

    protected void setFluid(FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : new ItemStack((ItemLike)this.container.getItem());
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 250 || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return 250;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

