/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BeeStingerEntity
extends AbstractArrow {
    public BeeStingerEntity(EntityType<? extends BeeStingerEntity> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(0.5);
    }

    public BeeStingerEntity(Level level, LivingEntity livingEntity, ItemStack ammo, @Nullable ItemStack weapon) {
        super((EntityType)BzEntities.BEE_STINGER_ENTITY.get(), livingEntity, level, ammo, weapon);
        this.setBaseDamage(0.5);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.getAbilities().instabuild) {
                this.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (!this.inGround) {
                this.makeParticle(4);
            }
        } else if (this.inGround && this.inGroundTime != 0 && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
        }
    }

    private void makeParticle(int particlesToSpawn) {
        if (particlesToSpawn > 0) {
            float red = 0.3f;
            float green = 0.3f;
            float blue = 0.3f;
            for (int i = 0; i < particlesToSpawn; ++i) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)red, (float)green, (float)blue), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity livingEntity) {
        if (!livingEntity.getType().is(EntityTypeTags.UNDEAD)) {
            boolean isPoisoned = livingEntity.hasEffect(MobEffects.POISON);
            boolean isSlowed = livingEntity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN);
            boolean isWeakened = livingEntity.hasEffect(MobEffects.WEAKNESS);
            boolean isParalyzed = livingEntity.hasEffect(BzEffects.PARALYZED.holder());
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 0, false, true, true));
            if (!isParalyzed && isPoisoned && livingEntity.getRandom().nextFloat() < 0.35f) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 180, 0, true, true, true));
            }
            if (!isParalyzed && isPoisoned && isSlowed && livingEntity.getRandom().nextFloat() < 0.3f) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0, true, true, true));
            }
            if (isPoisoned && isSlowed && isWeakened && livingEntity.getRandom().nextFloat() < 0.25f) {
                Entity entity;
                livingEntity.addEffect(new MobEffectInstance(BzEffects.PARALYZED.holder(), Math.min(BzGeneralConfigs.paralyzedMaxTickDuration, 100), 0, false, true, true));
                livingEntity.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                livingEntity.removeEffect(MobEffects.WEAKNESS);
                if (!livingEntity.isDeadOrDying() && (entity = this.getOwner()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    ((GenericTrigger)((Object)BzCriterias.BEE_STINGER_PARALYZE_TRIGGER.get())).trigger(serverPlayer);
                }
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return ((Item)BzItems.BEE_STINGER.get()).getDefaultInstance();
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)BzSounds.BEE_STINGER_HIT.get();
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

