/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.neoforge;

import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class DisableFlightAttribute {
    public static final ResourceLocation DISABLE_FLIGHT_RL = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"disable_flight");
    public static final AttributeModifier DISABLE_FLIGHT = new AttributeModifier(DISABLE_FLIGHT_RL, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public static void onPlayerTickToRemoveDisabledFlight(PlayerTickEvent.Pre event) {
        AttributeInstance attributeInstance;
        Player player = event.getEntity();
        if (!player.level().isClientSide() && player.level().getServer().getTickCount() % 40 == 5 && !player.isCreative() && !player.isSpectator() && player.isAlive() && (attributeInstance = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT)) != null && attributeInstance.hasModifier(DISABLE_FLIGHT_RL)) {
            DisableFlightAttribute.removeAttributeIfNotInHeavyAir(player, attributeInstance);
        }
    }

    private static void removeAttributeIfNotInHeavyAir(Player player, AttributeInstance attributeInstance) {
        AABB aABB = player.getBoundingBox();
        BlockPos blockPos = BlockPos.containing((double)(aABB.minX + 1.0E-7), (double)(aABB.minY + 1.0E-7), (double)(aABB.minZ + 1.0E-7));
        BlockPos blockPos2 = BlockPos.containing((double)(aABB.maxX - 1.0E-7), (double)(aABB.maxY - 1.0E-7), (double)(aABB.maxZ - 1.0E-7));
        if (player.level().hasChunksAt(blockPos, blockPos2)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int x = blockPos.getX(); x <= blockPos2.getX(); ++x) {
                for (int z = blockPos.getY(); z <= blockPos2.getY(); ++z) {
                    for (int y = blockPos.getZ(); y <= blockPos2.getZ(); ++y) {
                        mutableBlockPos.set(x, z, y);
                        BlockState blockState = player.level().getBlockState((BlockPos)mutableBlockPos);
                        if (!blockState.is((Block)BzBlocks.HEAVY_AIR.get())) continue;
                        return;
                    }
                }
            }
            attributeInstance.removeModifier(DISABLE_FLIGHT);
        }
    }
}

