/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class VariantBeeEntity
extends Bee {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(VariantBeeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final String VARIANT_TAG = "variant";

    public VariantBeeEntity(Level worldIn) {
        super((EntityType)BzEntities.VARIANT_BEE.get(), worldIn);
    }

    public VariantBeeEntity(EntityType<? extends VariantBeeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.getVariant();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getGoalSelector().addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, Bee.class));
    }

    public String getVariant() {
        String variant = (String)this.entityData.get(VARIANT);
        if (!(this.level().isClientSide() || variant != null && !variant.isEmpty() || BzGeneralConfigs.variantBeeTypes.isEmpty())) {
            variant = BzGeneralConfigs.variantBeeTypes.get(this.random.nextInt(BzGeneralConfigs.variantBeeTypes.size()));
            this.setVariant(variant);
        }
        return variant;
    }

    public void setVariant(String variant) {
        if (!(this.level().isClientSide() || variant != null && !variant.isEmpty() || BzGeneralConfigs.variantBeeTypes.isEmpty())) {
            variant = BzGeneralConfigs.variantBeeTypes.get(this.random.nextInt(BzGeneralConfigs.variantBeeTypes.size()));
        }
        this.entityData.set(VARIANT, (Object)variant);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)"");
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putString(VARIANT_TAG, this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setVariant(compoundTag.getString(VARIANT_TAG));
    }

    public boolean canMate(Animal animal) {
        if (animal.getClass().equals(Bee.class)) {
            return this.isInLove() && animal.isInLove();
        }
        return super.canMate(animal);
    }

    public Bee getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (ageableMob instanceof VariantBeeEntity) {
            VariantBeeEntity variantBeeEntity = (VariantBeeEntity)ageableMob;
            VariantBeeEntity babyBee = (VariantBeeEntity)((EntityType)BzEntities.VARIANT_BEE.get()).create((Level)serverLevel);
            if (babyBee != null) {
                babyBee.setVariant(this.random.nextBoolean() ? variantBeeEntity.getVariant() : this.getVariant());
            }
            return babyBee;
        }
        if (ageableMob instanceof Bee) {
            if (this.random.nextBoolean()) {
                VariantBeeEntity babyBee = (VariantBeeEntity)((EntityType)BzEntities.VARIANT_BEE.get()).create((Level)serverLevel);
                if (babyBee != null) {
                    babyBee.setVariant(this.getVariant());
                }
                return babyBee;
            }
            return (Bee)EntityType.BEE.create((Level)serverLevel);
        }
        return (Bee)((EntityType)BzEntities.VARIANT_BEE.get()).create((Level)serverLevel);
    }

    public void makeStuckInBlock(BlockState blockState, Vec3 speedMult) {
        if (blockState.getBlock() instanceof SweetBerryBushBlock) {
            return;
        }
        super.makeStuckInBlock(blockState, speedMult);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (damageSource == this.level().damageSources().sweetBerryBush()) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    protected Component getTypeName() {
        if (this.getVariant() != null) {
            return Component.translatable((String)("buzzing_briefcase.the_bumblezone.bee_typing." + this.getVariant()));
        }
        return this.getType().getDescription();
    }
}

