/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BeehemothRandomFlyGoal
extends Goal {
    private final BeehemothEntity beehemothEntity;
    private BlockPos target = null;

    public BeehemothRandomFlyGoal(BeehemothEntity beehemothEntity) {
        this.beehemothEntity = beehemothEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public void start() {
        this.target = this.getBlockInViewBeehemoth();
        if (this.target != null) {
            this.beehemothEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, (double)this.beehemothEntity.getFlyingSpeed());
        }
    }

    public boolean canUse() {
        MoveControl movementcontroller = this.beehemothEntity.getMoveControl();
        if (this.beehemothEntity.isStopWandering()) {
            return false;
        }
        if (!movementcontroller.hasWanted() || this.target == null) {
            this.target = this.getBlockInViewBeehemoth();
            if (this.target != null) {
                this.beehemothEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, (double)this.beehemothEntity.getFlyingSpeed());
            }
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.target != null && !this.beehemothEntity.isStopWandering() && this.beehemothEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) > 2.4 && this.beehemothEntity.getMoveControl().hasWanted() && !this.beehemothEntity.horizontalCollision;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        if (this.target == null) {
            this.target = this.getBlockInViewBeehemoth();
        }
        if (this.target != null) {
            double distance = this.beehemothEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target));
            if (distance < 2.5) {
                this.target = null;
                return;
            }
            float flyingSpeed = this.beehemothEntity.isVehicle() ? this.beehemothEntity.getFlyingSpeed() / 5.0f : this.beehemothEntity.getFlyingSpeed();
            this.beehemothEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, (double)flyingSpeed);
        }
    }

    public BlockPos getBlockInViewBeehemoth() {
        float radius = 3 + this.beehemothEntity.getRandom().nextInt(6);
        float neg = this.beehemothEntity.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.beehemothEntity.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.beehemothEntity.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(this.beehemothEntity.getX() + extraX), (double)(this.beehemothEntity.getY() + 2.0), (double)(this.beehemothEntity.getZ() + extraZ));
        BlockPos ground = this.getGroundPosition(this.beehemothEntity.level(), radialPos);
        BlockPos newPos = ground.above(1 + this.beehemothEntity.getRandom().nextInt(6));
        if (!this.beehemothEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.beehemothEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 6.0) {
            return newPos;
        }
        return null;
    }

    private BlockPos getGroundPosition(Level level, BlockPos radialPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.set((Vec3i)radialPos);
        while (level.isInWorldBounds((BlockPos)mutableBlockPos) && level.isEmptyBlock((BlockPos)mutableBlockPos)) {
            mutableBlockPos.move(Direction.DOWN);
        }
        if (!level.isInWorldBounds((BlockPos)mutableBlockPos)) {
            return radialPos;
        }
        return mutableBlockPos;
    }
}

