/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.advancements.EntitySpecificTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ProtectionOfTheHiveEffect
extends MobEffect {
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.forCombat().ignoreLineOfSight();

    public ProtectionOfTheHiveEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean isInstantenous() {
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration >= 1;
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        SEE_THROUGH_WALLS.range((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5);
        List beeList = livingEntity.level().getNearbyEntities(Bee.class, SEE_THROUGH_WALLS, livingEntity, livingEntity.getBoundingBox().inflate((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5));
        for (Bee bee : beeList) {
            if (bee.getTarget() != livingEntity || bee.isNoAi()) continue;
            bee.setTarget(null);
            bee.setPersistentAngerTarget(null);
            bee.setRemainingPersistentAngerTime(0);
        }
        super.onEffectStarted(livingEntity, amplifier);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.hurtTime > 0 && entity.getLastHurtByMob() != null) {
            Player player;
            LivingEntity livingEntity = entity.getLastHurtByMob();
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
                return true;
            }
            if (!(entity.getLastHurtByMob() instanceof Bee)) {
                ProtectionOfTheHiveEffect.resetBeeAngry(entity.level(), entity.getLastHurtByMob());
                entity.getLastHurtByMob().addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, amplifier, true, true, true));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    ((EntitySpecificTrigger)((Object)BzCriterias.PROTECTION_OF_THE_HIVE_DEFENSE_TRIGGER.get())).trigger(serverPlayer, (Entity)serverPlayer.getLastHurtByMob());
                }
            }
        }
        return true;
    }

    public static void resetBeeAngry(Level world, LivingEntity livingEntity) {
        LivingEntity entity = livingEntity;
        UUID uuid = entity.getUUID();
        SEE_THROUGH_WALLS.range((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5);
        List beeList = world.getNearbyEntities(Bee.class, SEE_THROUGH_WALLS, entity, entity.getBoundingBox().inflate((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5));
        if (livingEntity instanceof Bee) {
            entity = null;
            uuid = null;
        }
        for (Bee bee : beeList) {
            if (bee.isNoAi()) continue;
            bee.setTarget(entity);
            bee.setPersistentAngerTarget(uuid);
            if (entity != null) continue;
            bee.setRemainingPersistentAngerTime(0);
        }
    }
}

