/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterCommandsEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class NonOpCommands {
    private static MinecraftServer currentMinecraftServer = null;
    private static Set<String> cachedSuggestion = new HashSet<String>();

    public static void createCommand(BzRegisterCommandsEvent commandEvent) {
        String commandString = "bumblezone_read_self_data";
        String dataArg = "data_to_check";
        String entityArg = "entity_to_check";
        LiteralCommandNode source = commandEvent.dispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandString).requires(permission -> permission.hasPermission(0))).then(Commands.argument((String)dataArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(NonOpCommands.methodSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(cs -> {
            NonOpCommands.runMethod((String)cs.getArgument(dataArg, String.class), null, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })));
        commandEvent.dispatcher().register((LiteralArgumentBuilder)Commands.literal((String)commandString).redirect((CommandNode)source));
        LiteralCommandNode source2 = commandEvent.dispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandString).requires(permission -> permission.hasPermission(0))).then(Commands.literal((String)DATA_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name().toLowerCase(Locale.ROOT)).then(Commands.argument((String)entityArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(NonOpCommands.killedSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(cs -> {
            NonOpCommands.runMethod(DATA_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name(), (String)cs.getArgument(entityArg, String.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        commandEvent.dispatcher().register((LiteralArgumentBuilder)Commands.literal((String)commandString).redirect((CommandNode)source2));
    }

    private static Set<String> methodSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).getServer()) {
            return cachedSuggestion;
        }
        HashSet<String> suggestedStrings = new HashSet<String>();
        Arrays.stream(DATA_ARG.values()).forEach(e -> suggestedStrings.add(e.name().toLowerCase(Locale.ROOT)));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).getServer();
        cachedSuggestion = suggestedStrings;
        return suggestedStrings;
    }

    private static Set<String> killedSuggestions(CommandContext<CommandSourceStack> cs) {
        if (!((CommandSourceStack)cs.getSource()).isPlayer()) {
            return new HashSet<String>();
        }
        Player player = (Player)((CommandSourceStack)cs.getSource()).getEntity();
        AtomicReference suggestedStrings = new AtomicReference(new HashSet());
        ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> suggestedStrings.set(module.mobsKilledTracker.keySet().stream().map(killed -> "\"" + killed.toString() + "\"").collect(Collectors.toSet())));
        return suggestedStrings.get();
    }

    public static void runMethod(String dataString, String killedString, CommandContext<CommandSourceStack> cs) {
        Player player1;
        Player player;
        Entity entity = ((CommandSourceStack)cs.getSource()).getEntity();
        Player player2 = player = entity instanceof Player ? (player1 = (Player)entity) : null;
        if (player instanceof ServerPlayer) {
            DATA_ARG dataArg;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                dataArg = DATA_ARG.valueOf(dataString.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                MutableComponent mutableComponent = Component.translatable((String)"command.the_bumblezone.invalid_data_arg");
                player.displayClientMessage((Component)mutableComponent, false);
                return;
            }
            if (DATA_ARG.IS_BEE_ESSENCED.equals((Object)dataArg)) {
                boolean hasBeeEssence = EssenceOfTheBees.hasEssence(serverPlayer);
                MutableComponent mutableComponent = Component.translatable((String)(hasBeeEssence ? "command.the_bumblezone.have_bee_essence" : "command.the_bumblezone.does_not_have_bee_essence"), (Object[])new Object[]{serverPlayer.getDisplayName()});
                player.displayClientMessage((Component)mutableComponent, false);
                return;
            }
            if (!PlayerDataHandler.rootAdvancementDone(serverPlayer)) {
                player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_not_active", (Object[])new Object[]{serverPlayer.getDisplayName()}), false);
                return;
            }
            switch (dataArg.ordinal()) {
                case 1: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_crafted_beehive", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.craftedBeehives}), false));
                    break;
                }
                case 2: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_bees_bred", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.beesBred}), false));
                    break;
                }
                case 3: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_flowers_spawned", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.flowersSpawned}), false));
                    break;
                }
                case 4: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_honey_bottle_drank", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.honeyBottleDrank}), false));
                    break;
                }
                case 5: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_bee_stingers_fired", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.beeStingersFired}), false));
                    break;
                }
                case 6: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_bee_saved", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.beeSaved}), false));
                    break;
                }
                case 7: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_pollen_puff_hits", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.pollenPuffHits}), false));
                    break;
                }
                case 8: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_honey_slime_bred", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.honeySlimeBred}), false));
                    break;
                }
                case 9: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_bees_fed", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.beesFed}), false));
                    break;
                }
                case 10: {
                    ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_queen_bee_trade", (Object[])new Object[]{serverPlayer.getDisplayName(), capability.queenBeeTrade}), false));
                    break;
                }
                case 11: {
                    if (killedString != null) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                            ResourceLocation rl = ResourceLocation.tryParse((String)killedString);
                            int killed = capability.mobsKilledTracker.getOrDefault((Object)rl, 0);
                            String translationKey = rl.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ender_dragon")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_ender_dragon" : (rl.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_wither" : "command.the_bumblezone.queens_desired_killed_entity_counter");
                            if (BuiltInRegistries.ENTITY_TYPE.containsKey(rl)) {
                                player.displayClientMessage((Component)Component.translatable((String)translationKey, (Object[])new Object[]{serverPlayer.getDisplayName(), killed, Component.translatable((String)Util.makeDescriptionId((String)"entity", (ResourceLocation)rl))}), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)translationKey, (Object[])new Object[]{serverPlayer.getDisplayName(), killed, Component.translatable((String)("tag.entity_type." + killedString.replaceAll("[\\\\:/-]", ".")))}), false);
                            }
                        });
                        break;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"command.the_bumblezone.invalid_entity_arg", (Object[])new Object[]{serverPlayer.getDisplayName()}), false);
                    break;
                }
            }
        }
    }

    static enum DATA_ARG {
        IS_BEE_ESSENCED,
        QUEENS_DESIRED_CRAFTED_BEEHIVE,
        QUEENS_DESIRED_BEES_BRED,
        QUEENS_DESIRED_FLOWERS_SPAWNED,
        QUEENS_DESIRED_HONEY_BOTTLE_DRANK,
        QUEENS_DESIRED_BEE_STINGERS_FIRED,
        QUEENS_DESIRED_BEE_SAVED,
        QUEENS_DESIRED_POLLEN_PUFF_HITS,
        QUEENS_DESIRED_HONEY_SLIME_BRED,
        QUEENS_DESIRED_BEES_FED,
        QUEENS_DESIRED_QUEEN_BEE_TRADE,
        QUEENS_DESIRED_KILLED_ENTITY_COUNTER;

    }
}

