/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminRenderer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class RootminGrassRenderer
extends RenderLayer<RootminEntity, RootminModel> {
    private static final ResourceLocation GRASS = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/rootmin_grass.png");
    private final RootminModel model;
    private final RootminRenderer renderLayerParent;

    public RootminGrassRenderer(RootminRenderer renderLayerParent, EntityModelSet entityModelSet) {
        super((RenderLayerParent)renderLayerParent);
        this.model = new RootminModel(entityModelSet.bakeLayer(RootminModel.LAYER_LOCATION));
        this.renderLayerParent = renderLayerParent;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, RootminEntity entity, float f, float g, float partialTicks, float j, float k, float l) {
        poseStack.pushPose();
        this.renderGrassBodyTop(entity, partialTicks, poseStack, multiBufferSource, packedLight);
        poseStack.popPose();
    }

    private void renderGrassBodyTop(RootminEntity rootminEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        Entity entity;
        this.model.attackTime = this.renderLayerParent.getAttackAnim(rootminEntity, partialTicks);
        this.model.riding = rootminEntity.isPassenger();
        this.model.young = rootminEntity.isBaby();
        float h = Mth.rotLerp((float)partialTicks, (float)rootminEntity.yBodyRotO, (float)rootminEntity.yBodyRot);
        float j = Mth.rotLerp((float)partialTicks, (float)rootminEntity.yHeadRotO, (float)rootminEntity.yHeadRot);
        float k = j - h;
        if (rootminEntity.isPassenger() && (entity = rootminEntity.getVehicle()) instanceof LivingEntity) {
            LivingEntity rootminEntity2 = (LivingEntity)entity;
            h = Mth.rotLerp((float)partialTicks, (float)rootminEntity2.yBodyRotO, (float)rootminEntity2.yBodyRot);
            k = j - h;
            float l = Mth.wrapDegrees((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            h = j - l;
            if (l * l > 2500.0f) {
                h += l * 0.2f;
            }
            k = j - h;
        }
        float m = Mth.lerp((float)partialTicks, (float)rootminEntity.xRotO, (float)rootminEntity.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)rootminEntity)) {
            m *= -1.0f;
            k *= -1.0f;
        }
        float l = this.renderLayerParent.getBob(rootminEntity, partialTicks);
        float belowEyeHeight = 0.0f;
        float o = 0.0f;
        if (!rootminEntity.isPassenger() && rootminEntity.isAlive()) {
            belowEyeHeight = rootminEntity.walkAnimation.speed(partialTicks);
            o = rootminEntity.walkAnimation.position(partialTicks);
            if (rootminEntity.isBaby()) {
                o *= 3.0f;
            }
            if (belowEyeHeight > 1.0f) {
                belowEyeHeight = 1.0f;
            }
        }
        this.model.prepareMobModel((Entity)rootminEntity, o, belowEyeHeight, partialTicks);
        this.model.setupAnim(rootminEntity, o, belowEyeHeight, l, k, m);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = this.renderLayerParent.isBodyVisible(rootminEntity);
        boolean bl2 = !bl && !rootminEntity.isInvisibleTo((Player)minecraft.player);
        boolean bl3 = minecraft.shouldEntityAppearGlowing((Entity)rootminEntity);
        RenderType renderType = this.getRenderTypeGrass(bl, bl2, bl3);
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
            int p = LivingEntityRenderer.getOverlayCoords((LivingEntity)rootminEntity, (float)this.renderLayerParent.getWhiteOverlayProgress(rootminEntity, partialTicks));
            if (rootminEntity.hasCustomName() && "jeb_".equals(rootminEntity.getName().getString())) {
                int speed = 25;
                int offset = rootminEntity.tickCount / speed + rootminEntity.getId();
                int dyeColors = DyeColor.values().length;
                int firstDye = offset % dyeColors;
                int secondDye = (offset + 1) % dyeColors;
                float theColorThingy = ((float)(rootminEntity.tickCount % speed) + partialTicks) / 25.0f;
                int fs = Sheep.getColor((DyeColor)DyeColor.byId((int)firstDye));
                int gs = Sheep.getColor((DyeColor)DyeColor.byId((int)secondDye));
                int color = FastColor.ARGB32.lerp((float)theColorThingy, (int)fs, (int)gs);
                this.model.renderToBuffer(stack, vertexConsumer, packedLight, p, color);
            } else {
                int biomeColor = rootminEntity.level().getBlockTint(rootminEntity.blockPosition(), BiomeColors.GRASS_COLOR_RESOLVER);
                this.model.renderToBuffer(stack, vertexConsumer, packedLight, p, FastColor.ARGB32.color((int)(bl2 ? 38 : 255), (int)GeneralUtils.getRed(biomeColor), (int)GeneralUtils.getGreen(biomeColor), (int)GeneralUtils.getBlue(biomeColor)));
            }
        }
    }

    protected RenderType getRenderTypeGrass(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)GRASS);
        }
        if (bl) {
            return this.model.renderType(GRASS);
        }
        if (bl3) {
            return RenderType.outline((ResourceLocation)GRASS);
        }
        return null;
    }

    protected float xOffset(float f) {
        return f * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        return GRASS;
    }

    protected EntityModel<RootminEntity> model() {
        return this.model;
    }
}

