/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.fluids;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class FluidClientOverlay {
    private static final ResourceLocation HONEY_TEXTURE_UNDERWATER = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/misc/honey_fluid_underwater.png");
    private static final ResourceLocation ROYAL_JELLY_TEXTURE_UNDERWATER = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/misc/royal_jelly_fluid_underwater.png");

    public static boolean renderHoneyOverlay(Player clientPlayerEntity, PoseStack matrixStack) {
        BlockState state = clientPlayerEntity.level().getBlockState(BlockPos.containing((Position)clientPlayerEntity.getEyePosition(1.0f)));
        if (state.is((Block)BzFluids.HONEY_FLUID_BLOCK.get()) || state.is((Block)BzFluids.ROYAL_JELLY_FLUID_BLOCK.get())) {
            if (state.hasProperty((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                double yOffset = Math.abs(clientPlayerEntity.getEyePosition(1.0f).y() - Math.floor(clientPlayerEntity.getEyePosition(1.0f).y()));
                if ((double)((Integer)state.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                    return false;
                }
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(state.is((Block)BzFluids.HONEY_FLUID_BLOCK.get()) ? HONEY_TEXTURE_UNDERWATER : ROYAL_JELLY_TEXTURE_UNDERWATER));
            float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes((Entity)clientPlayerEntity), 2.0), (double)clientPlayerEntity.level().dimensionType().ambientLight());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] olderShaderColor = (float[])RenderSystem.getShaderColor().clone();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.95f);
            float modifiedYaw = -clientPlayerEntity.getYRot() / 512.0f;
            float modifiedPitch = clientPlayerEntity.getXRot() / 512.0f;
            Matrix4f matrix4f = matrixStack.last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(1.0f + modifiedYaw, 1.0f + modifiedPitch);
            bufferBuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + modifiedYaw, 2.0f + modifiedPitch);
            bufferBuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(1.0f + modifiedYaw, 1.0f + modifiedPitch);
            bufferBuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(2.0f + modifiedYaw, 0.0f + modifiedPitch);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)olderShaderColor[0], (float)olderShaderColor[1], (float)olderShaderColor[2], (float)olderShaderColor[3]);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public static float getDimensionBrightnessAtEyes(Entity entity) {
        float lightLevelAtEyes;
        Level level = entity.level();
        if (level.dimensionType().hasSkyLight()) {
            lightLevelAtEyes = level.getRawBrightness(BlockPos.containing((Position)entity.getEyePosition(1.0f)), level.getSkyDarken());
            level.updateSkyBrightness();
            if (level.isNight()) {
                float moonBrightness = level.getMoonBrightness();
                lightLevelAtEyes *= moonBrightness;
            }
        } else {
            lightLevelAtEyes = level.getRawBrightness(BlockPos.containing((Position)entity.getEyePosition(1.0f)), 0);
        }
        return lightLevelAtEyes / 15.0f;
    }
}

