/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.blockentityrenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import org.joml.Matrix4f;

public class EssenceBlockEntityRenderer
implements BlockEntityRenderer<EssenceBlockEntity> {
    private static final long RANDOM_SEED = 31100L;
    private static final Random RANDOM = new Random(31100L);
    public static final ResourceLocation BASE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/block/essence/base_background.png");
    public static final ResourceLocation BEE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/block/essence/bee_icon_background.png");
    public static final VertexFormat POSITION_COLOR_NORMAL = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("Normal", VertexFormatElement.NORMAL).build();
    public static ShaderInstance SAFE_SHADER_INSTANCE = null;
    public final RenderType.CompositeRenderType ESSENCE_RENDER_TYPE = RenderType.create((String)"bumblezone_essence_block", (VertexFormat)POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> SAFE_SHADER_INSTANCE)).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(BASE_TEXTURE, false, false).add(BEE_TEXTURE, false, false).build()).createCompositeState(false));

    public EssenceBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EssenceBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int brightness, int overlayType) {
        if (BzClientConfigs.disableEssenceBlockShaders) {
            return;
        }
        RANDOM.setSeed(31100L);
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderSides(blockEntity, matrix4f, multiBufferSource.getBuffer(this.getType()));
    }

    private void renderSides(EssenceBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        int colorInt = blockEntity.getBlockState().getMapColor((BlockGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()).col;
        float red = (float)FastColor.ARGB32.red((int)colorInt) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)colorInt) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)colorInt) / 255.0f;
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, red, green, blue, Direction.SOUTH);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, red, green, blue, Direction.NORTH);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.EAST);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.WEST);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, red, green, blue, Direction.DOWN);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, red, green, blue, Direction.UP);
    }

    private void renderSide(EssenceBlockEntity blockEntity, Matrix4f model, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4, float red, float green, float blue, Direction direction) {
        if (blockEntity.shouldDrawSide(direction)) {
            Vec3i normal = direction.getNormal();
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x1, y1, z1, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x2, y1, z2, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x2, y2, z3, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x1, y2, z4, red, green, blue, normal);
        }
    }

    private static void addPortalVertex(VertexConsumer vertexConsumer, Matrix4f mat, float x, float y, float z, float red, float green, float blue, Vec3i normal) {
        vertexConsumer.addVertex(mat, x, y, z).setColor(red, green, blue, 1.0f).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    protected RenderType getType() {
        return this.ESSENCE_RENDER_TYPE;
    }
}

