/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.datamanagers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;

public class PotionCandleDataManager
extends SimpleJsonResourceReloadListener {
    public static final PotionCandleDataManager POTION_CANDLE_DATA_MANAGER = new PotionCandleDataManager();
    public final Map<MobEffect, OverrideData> effectToOverrideStats = new Object2ObjectArrayMap();

    public PotionCandleDataManager() {
        super(Bumblezone.GSON, "bz_potion_candle_data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.effectToOverrideStats.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                EffectData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(s -> {}).ifPresent(data -> this.effectToOverrideStats.put((MobEffect)data.effectHolder().value(), data.overrideData()));
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse potion candle data file: {}", fileIdentifier, (Object)e);
            }
        });
    }

    public record EffectData(Holder<MobEffect> effectHolder, OverrideData overrideData) {
        public static final Codec<EffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(e -> e.effectHolder), (App)OverrideData.CODEC.fieldOf("override").forGetter(i -> i.overrideData)).apply((Applicative)instance, instance.stable(EffectData::new)));
    }

    public record OverrideData(Integer maxLevelCap, Integer minLevelCap, Integer maxBurnDurationCap, Integer minBurnDurationCap, Optional<Integer> baseLingerTime) {
        public static final Codec<OverrideData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.intRange((int)0, (int)100000000).fieldOf("max_level_cap").orElse((Object)100000000).forGetter(i -> i.maxLevelCap), (App)ExtraCodecs.intRange((int)0, (int)100000000).fieldOf("min_level_cap").orElse((Object)0).forGetter(i -> i.minLevelCap), (App)ExtraCodecs.intRange((int)1, (int)100000000).fieldOf("max_burn_duration_cap_in_seconds").orElse((Object)100000000).forGetter(i -> i.maxBurnDurationCap), (App)ExtraCodecs.intRange((int)1, (int)100000000).fieldOf("min_burn_duration_cap_in_seconds").orElse((Object)1).forGetter(i -> i.maxBurnDurationCap), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("linger_base_duration_in_seconds").forGetter(i -> i.baseLingerTime)).apply((Applicative)instance, instance.stable(OverrideData::new)));
    }
}

