/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.WaveSounds;
import waves.client.particle.WaveParticleOption;
import waves.config.Config;
import waves.util.WaveHelpers;

@OnlyIn(value=Dist.CLIENT)
public class WaveParticle
extends TextureSheetParticle {
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public float size;
    public float speed;
    public double initialDistance;
    public double angleToShore;
    public int waveSize;
    public int surroundWaterBlocks;
    public static double minDistance = Double.MAX_VALUE;
    public int waveSpriteOld;
    public double distanceOld;
    public double waveSpeedOld;
    public ResourceLocation waveTexture;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlayedSound = false;

    public WaveParticle(ClientLevel level, Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        super(level, startPos.x(), startPos.y(), startPos.z());
        this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + WaveHelpers.toSize(waveSize).toLowerCase() + "_0.png");
        this.scale(scale);
        this.setSize(size, size);
        this.xd = direction.x() * (double)speed;
        this.zd = direction.z() * (double)speed;
        this.quadSize = size * 0.5f;
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.alpha = 0.0f;
        this.hasPhysics = false;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.size = size;
        this.speed = speed;
        this.initialDistance = startPos.distanceTo(shorePos);
        this.angleToShore = WaveHelpers.calculateAngleToTarget(startPos, shorePos);
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.waveSpriteOld = 0;
        this.distanceOld = Double.MAX_VALUE;
    }

    public void tick() {
        float soundMod;
        boolean shouldDecay;
        Vec3 currentPos = new Vec3(this.x, this.y, this.z);
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        double distance = currentPos.distanceTo(this.shorePos);
        boolean hasFluidBelow = !this.level.getFluidState(blockPos.below()).isEmpty();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        if (this.waveSpriteOld < waveSprite) {
            this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + WaveHelpers.toSize(this.waveSize).toLowerCase() + "_" + waveSprite + ".png");
        }
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).length();
        boolean bl = shouldDecay = this.hasReachedShore || vecSpeed == 0.0 || waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1;
        if (!shouldDecay) {
            this.setAlpha(Mth.clamp((float)(this.alpha + 0.025f), (float)0.0f, (float)1.0f));
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                this.setAlpha(1.0f);
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.z() * 0.015;
                this.xd = vecInverse.x() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.distanceTo(this.shorePos) <= 2.0) {
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).length() * 0.02);
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        if ((!hasFluidBelow || this.waveSpeedOld == vecSpeed || distance > this.distanceOld) && this.hasReachedShore) {
            this.setAlpha(Mth.clamp((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f));
        }
        if (hasFluidBelow && this.hasTouchedLand) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            this.setAlpha(Mth.clamp((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f));
        }
        this.move(this.xd, 0.0, this.zd);
        if (this.alpha <= 0.01f || this.age > 600) {
            this.remove();
        }
        ++this.age;
        this.waveSpeedOld = vecSpeed;
        this.distanceOld = distance;
        if (this.waveSpriteOld <= waveSprite) {
            this.waveSpriteOld = waveSprite;
        }
        if (currentPos.distanceTo(this.shorePos) < 4.0 && this.random.nextInt((Integer)Config.COMMON.waveBreakingSoundChance.get() + 1) == 0 && !this.hasPlayedSound && (soundMod = (float)WaveHelpers.soundDistanceMod((Player)Minecraft.getInstance().player, this.shorePos, 60.0, 10.0)) > 0.0f) {
            float rainfall = 1.0f + this.level.getRainLevel(1.0f) * 0.5f;
            WaveHelpers.playSound((Level)this.level, this.random, WaveHelpers.toBlockPos(this.shorePos), (SoundEvent)WaveSounds.WAVES_BREAKING.get(), SoundSource.AMBIENT, true, rainfall * 0.5f * soundMod * ((Double)Config.COMMON.waveVolume.get()).floatValue());
            this.hasPlayedSound = true;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Vec3 wavePos = new Vec3(this.x, this.y, this.z);
        LocalPlayer player = minecraft.player;
        if (WaveHelpers.isWithinAngle(wavePos, (Player)player, ((Integer)minecraft.options.fov().get()).doubleValue() + 5.0) && player.getEyePosition().distanceTo(wavePos) <= ((Integer)minecraft.options.renderDistance().get()).doubleValue() * 16.0) {
            PoseStack poseStack = new PoseStack();
            poseStack.pushPose();
            Matrix4f matrix = poseStack.last().pose();
            RenderSystem.enableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.waveTexture);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
            Vec3 vec3 = camera.getPosition();
            float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
            float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
            float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
            Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.YN.rotation((float)(this.angleToShore - 1.5707963267948966))).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            Vector3f[] avector3 = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            float quadSize = this.getQuadSize(partialTicks);
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3 = avector3[i];
                vector3.rotate((Quaternionfc)quaternion);
                vector3.mul(quadSize);
                vector3.add(x, y, z);
            }
            float u0 = 0.0f;
            float u1 = 1.0f;
            float v0 = 0.0f;
            float v1 = 1.0f;
            double dayTime = (double)this.level.getDayTime() * (Double)Config.COMMON.waveBioluminescenceFrequency.get();
            double speed = new Vec3(this.xd, 0.0, this.zd).length() * 10.0;
            double skyBrightness = WaveHelpers.getSkyBrightness((Level)this.level, partialTicks);
            double bioluminescenceNoise = Mth.clamp((double)(WaveHelpers.bioluminescenceNoise((Level)this.level, 10L, (Integer)Config.COMMON.waveBioluminescenceChange.get()).noise(dayTime + this.x, dayTime + this.z) * speed), (double)0.0, (double)1.0) * (1.0 - skyBrightness);
            bioluminescenceNoise = bioluminescenceNoise < 0.05 ? 0.0 : bioluminescenceNoise;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            int j = 0xF000F0;
            if (player.hasEffect(MobEffects.NIGHT_VISION) && !player.hasEffect(MobEffects.DARKNESS)) {
                float nightVision = GameRenderer.getNightVisionScale((LivingEntity)player, (float)partialTicks);
                r *= nightVision;
                g *= nightVision;
                b *= nightVision;
                j = Mth.floor((double)(1.572888E7 * (double)nightVision));
            } else {
                r = (float)Mth.clamp((double)skyBrightness, (double)0.1, (double)1.0);
                g = (float)Mth.clamp((double)(skyBrightness + bioluminescenceNoise * 0.8), (double)0.1, (double)1.0);
                b = (float)Mth.clamp((double)(skyBrightness + bioluminescenceNoise), (double)0.1, (double)1.0);
                BlockPos posBehind = WaveHelpers.toBlockPos(WaveHelpers.getPositionOffset(wavePos, this.angleToShore, 180.0, 6.0));
                j = (int)Math.round(Mth.clamp((double)((double)(this.level.isLoaded(posBehind) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)posBehind) : this.getLightColor(partialTicks)) + 1.0E7 * bioluminescenceNoise), (double)0.0, (double)1.572888E7));
            }
            float a = Mth.clamp((float)this.alpha, (float)0.0f, (float)1.0f);
            builder.addVertex(matrix, avector3[0].x(), avector3[0].y(), avector3[0].z()).setColor(r, g, b, a).setUv(u1, v1).setLight(j);
            builder.addVertex(matrix, avector3[1].x(), avector3[1].y(), avector3[1].z()).setColor(r, g, b, a).setUv(u1, v0).setLight(j);
            builder.addVertex(matrix, avector3[2].x(), avector3[2].y(), avector3[2].z()).setColor(r, g, b, a).setUv(u0, v0).setLight(j);
            builder.addVertex(matrix, avector3[3].x(), avector3[3].y(), avector3[3].z()).setColor(r, g, b, a).setUv(u0, v1).setLight(j);
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            poseStack.popPose();
        }
    }

    public static ParticleProvider<WaveParticleOption> provider(SpriteSet set) {
        return (type, level, x, y, z, dx, dy, dz) -> {
            WaveParticle particle = new WaveParticle(level, type.getStartPos(), type.getShorePos(), type.getDirection(), type.getScale(), type.getSize(), type.getSpeed(), type.getWaveSize(), type.getSurroundWaterBlocks());
            particle.setPos(type.getStartPos().x(), type.getStartPos().y(), type.getStartPos().z());
            return particle;
        };
    }
}

