/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.compat;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.cg360.mod.bridging.compat.GroupSelector;
import me.cg360.mod.bridging.compat.SpecialBridgingHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;

public class SpecialHandlers {
    private static HashMap<ResourceLocation, SpecialBridgingHandler> specialHandlers = new HashMap();
    private static LinkedList<SpecialGroupHandlerEntry> specialHandlerGroups = new LinkedList();
    public static List<Function<Block, Boolean>> slabAssistFilters = new LinkedList<Function<Block, Boolean>>();

    public static void registerSpecialHandler(ResourceLocation itemId, SpecialBridgingHandler handler) {
        specialHandlers.put(itemId, handler);
    }

    public static void registerSpecialHandler(Item item, SpecialBridgingHandler handler) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
        specialHandlers.put(itemKey, handler);
    }

    public static void registerSpecialGroupHandler(SpecialBridgingHandler handler, GroupSelector item) {
        SpecialGroupHandlerEntry entry = new SpecialGroupHandlerEntry(handler, item);
        specialHandlerGroups.add(entry);
    }

    public static Optional<SpecialBridgingHandler> getSpecialHandler(ItemStack itemStack) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        if (specialHandlers.containsKey(itemKey)) {
            return Optional.of(specialHandlers.get(itemKey));
        }
        return specialHandlerGroups.stream().filter(groupHandler -> groupHandler.groupSelector.passes(itemStack)).findFirst().map(entry -> entry.handler);
    }

    public static boolean hasSpecialHandler(ItemStack item) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        if (specialHandlers.containsKey(itemKey)) {
            return true;
        }
        return specialHandlerGroups.stream().map(SpecialGroupHandlerEntry::groupSelector).anyMatch(selector -> selector.passes(item));
    }

    static {
        slabAssistFilters.add(block -> block instanceof SlabBlock);
        slabAssistFilters.add(block -> block instanceof TrapDoorBlock);
    }

    public record SpecialGroupHandlerEntry(SpecialBridgingHandler handler, GroupSelector groupSelector) {
    }
}

