/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.client.BlockScanner;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WallLanternModelsManager {
    private static final Map<Block, ResourceLocation> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<Block, ResourceLocation>();
    private static final Map<Block, ModelResourceLocation> SPECIAL_LANTERN_MODELS = new IdentityHashMap<Block, ModelResourceLocation>();

    public static void refreshModels(ResourceManager manager) {
        WallLanternModelsManager.reloadTextures(manager);
        WallLanternModelsManager.reloadModels(manager);
    }

    private static void reloadModels(ResourceManager manager) {
        SPECIAL_LANTERN_MODELS.clear();
        for (Block l : BlockScanner.getLanterns()) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.getNamespace().equals("minecraft") || reg.getNamespace().equals("amendments") ? "" : reg.getNamespace() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.getPath();
            ResourceLocation fullPath = Amendments.res("models/" + s + ".json");
            Optional resource = manager.getResource(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, RenderUtil.getStandaloneModelLocation((ResourceLocation)Amendments.res(s)));
        }
    }

    private static void reloadTextures(ResourceManager manager) {
        SPECIAL_MOUNT_TEXTURES.clear();
        for (Block l : BlockScanner.getLanterns()) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.getNamespace().equals("minecraft") || reg.getNamespace().equals("amendments") ? "" : reg.getNamespace() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.getPath() + ".json";
            ResourceLocation fullPath = Amendments.res(s);
            Optional resource = manager.getResource(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((Resource)resource.get()).open();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, ResourceLocation.tryParse((String)texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static TextureAtlasSprite getTexture(Block block) {
        ResourceLocation res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(e -> event.register(e.id()));
    }

    public static BakedModel getModel(BlockModelShaper blockModelShaper, BlockState lantern) {
        ModelResourceLocation special = SPECIAL_LANTERN_MODELS.get(lantern.getBlock());
        if (special != null) {
            return ClientHelper.getModel((ModelManager)Minecraft.getInstance().getModelManager(), (ModelResourceLocation)special);
        }
        return blockModelShaper.getBlockModel(lantern);
    }
}

