/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface Texter {
    public static final Component LINE_BREAK = Texter.literal("\n");
    public static final Component SPACE = Texter.literal(" ");
    public static final Component NERUINA_HEADER = Texter.withStyle(Texter.literal("[Neruina]: "), style -> style.withColor(ChatFormatting.AQUA));

    public static Component literal(String component) {
        return Component.literal((String)component);
    }

    public static Component translatable(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static Component empty() {
        return Component.empty();
    }

    public static Component withStyle(Component component, UnaryOperator<Style> style) {
        if (component instanceof MutableComponent) {
            MutableComponent mutableComponent = (MutableComponent)component;
            mutableComponent.withStyle(style);
        }
        return component;
    }

    public static Component concat(Component ... texts) {
        MutableComponent component = Component.empty();
        for (Component t : texts) {
            if (t.getString().isEmpty()) continue;
            component.append(t);
        }
        return component;
    }

    public static Component concatDelimited(Component delimiter, Component ... texts) {
        MutableComponent component = Component.empty();
        for (int i = 0; i < texts.length; ++i) {
            component.append(texts[i]);
            if (texts[i].getString().isEmpty()) {
                List siblings = component.getSiblings();
                if (siblings.isEmpty()) continue;
                siblings.removeLast();
                continue;
            }
            if (i == texts.length - 1) continue;
            component.append(delimiter);
        }
        return component;
    }

    public static Component pad(Component component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        MutableComponent padded = Component.empty();
        padded.append(LINE_BREAK);
        padded.append(component);
        padded.append(LINE_BREAK);
        return padded;
    }

    public static Component format(Component component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        return Texter.concat(NERUINA_HEADER, Texter.withStyle(component, style -> style.withColor(ChatFormatting.RED)));
    }

    public static ClickEvent clickEvent(ClickEvent.Action action, String value) {
        return new ClickEvent(action, value);
    }

    public static <T> HoverEvent hoverEvent(HoverEvent.Action<T> action, T value) {
        return new HoverEvent(action, value);
    }
}

