/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.util;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.CrashReportCategoryExtender;
import com.bawnorton.neruina.handler.PersitanceHandler;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.Reflection;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public final class TickingEntry {
    public static final Codec<TickingEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("causeType").forGetter(TickingEntry::getCauseType), (App)Codec.STRING.fieldOf("causeName").forGetter(TickingEntry::getCauseName), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(TickingEntry::uuid), (App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(TickingEntry::dimension), (App)BlockPos.CODEC.fieldOf("pos").forGetter(TickingEntry::pos), (App)ThrowableData.CODEC.fieldOf("error").forGetter(tickingEntry -> ThrowableData.fromThrowable(tickingEntry.error())), (App)UUIDUtil.CODEC.optionalFieldOf("entityUuid").forGetter(tickingEntry -> {
        try {
            if (tickingEntry.getCauseType().equals(Type.ENTITY.type)) {
                if (tickingEntry.cachedEntityUuid != null) {
                    return Optional.of(tickingEntry.cachedEntityUuid);
                }
                Object patt0$temp = tickingEntry.getCause();
                if (patt0$temp instanceof Entity) {
                    Entity entity = (Entity)patt0$temp;
                    tickingEntry.cachedEntityUuid = entity.getUUID();
                    return Optional.of(tickingEntry.cachedEntityUuid);
                }
            }
        }
        catch (RuntimeException e) {
            Neruina.LOGGER.warn("Failed to find entity UUID when serializing TickingEntry", (Throwable)e);
        }
        return Optional.empty();
    })).apply((Applicative)instance, (causeType, causeName, uuid, dimension, pos, error, entityUuid) -> {
        Supplier<Object> cause = () -> null;
        if (causeType.equals(Type.ENTITY.type)) {
            if (entityUuid.isPresent()) {
                UUID entityUuidValue = (UUID)entityUuid.get();
                cause = () -> PersitanceHandler.getLevel().getEntity(entityUuidValue);
            }
        } else if (causeType.equals(Type.BLOCK_ENTITY.type)) {
            cause = () -> PersitanceHandler.getLevel().getBlockEntity(pos);
        } else if (causeType.equals(Type.BLOCK_STATE.type)) {
            cause = () -> PersitanceHandler.getLevel().getBlockState(pos);
        }
        TickingEntry entry = new TickingEntry(cause, true, (ResourceKey<Level>)dimension, (BlockPos)pos, (UUID)uuid, error.toThrowable());
        entry.cachedCauseType = causeType;
        entry.cachedCauseName = causeName;
        return entry;
    }));
    private final Supplier<Object> causeSupplier;
    private final boolean persitent;
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final Throwable error;
    private final UUID uuid;
    private String cachedCauseType;
    private String cachedCauseName;
    private UUID cachedEntityUuid;
    private final List<String> blacklistedModids = List.of("neruina", "minecraft", "forge", "neoforge");

    public TickingEntry(Object cause, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, Throwable error) {
        this.causeSupplier = () -> cause;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.error = error;
        this.uuid = UUID.randomUUID();
        this.update();
    }

    private TickingEntry(Supplier<Object> causeSupplier, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, UUID uuid, Throwable error) {
        this.causeSupplier = causeSupplier;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.uuid = uuid;
        this.error = error;
    }

    public void populate(CrashReportCategory category) {
        Object cause;
        category.setDetail("Message", (Object)this.error.getMessage());
        ((CrashReportCategoryExtender)category).neruin$setStacktrace(this.error);
        Object object = cause = this.getCause();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Entity.class, BlockEntity.class, BlockState.class, ItemStack.class}, (Object)object, n)) {
            case 0: {
                Entity entity = (Entity)object;
                entity.fillCrashReportCategory(category);
                break;
            }
            case 1: {
                BlockEntity blockEntity = (BlockEntity)object;
                blockEntity.fillCrashReportCategory(category);
                break;
            }
            case 2: {
                BlockState state = (BlockState)object;
                category.setDetail("Position", (Object)this.pos);
                category.setDetail("BlockState", (Object)state);
                break;
            }
            case 3: {
                ItemStack stack = (ItemStack)object;
                category.setDetail("ItemStack", (Object)stack);
                break;
            }
            default: {
                category.setDetail("Errored", (Object)"Unknown");
            }
        }
    }

    public String createCrashReport() {
        CrashReport report = new CrashReport("Ticking %s".formatted(this.getCauseType()), this.error);
        CrashReportCategory category = report.addCategory("Source: %s".formatted(this.getCauseName()));
        this.populate(category);
        return report.getFriendlyReport(ReportType.CRASH);
    }

    public Object getCause() {
        return this.causeSupplier.get();
    }

    public void update() {
        Object cause;
        Object object = cause = this.causeSupplier.get();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Entity.class, BlockEntity.class, BlockState.class, ItemStack.class}, (Object)object, n)) {
            case 0: {
                Entity entity = (Entity)object;
                this.cachedCauseType = Type.ENTITY.type;
                this.cachedCauseName = Type.ENTITY.nameFunction.apply(entity);
                break;
            }
            case 1: {
                BlockEntity blockEntity = (BlockEntity)object;
                this.cachedCauseType = Type.BLOCK_ENTITY.type;
                this.cachedCauseName = Type.BLOCK_ENTITY.nameFunction.apply(blockEntity);
                break;
            }
            case 2: {
                BlockState state = (BlockState)object;
                this.cachedCauseType = Type.BLOCK_STATE.type;
                this.cachedCauseName = Type.BLOCK_STATE.nameFunction.apply(state);
                break;
            }
            case 3: {
                ItemStack stack = (ItemStack)object;
                this.cachedCauseType = Type.ITEM_STACK.type;
                this.cachedCauseName = Type.ITEM_STACK.nameFunction.apply(stack);
                break;
            }
            default: {
                this.cachedCauseType = Type.UNKNOWN.type;
                this.cachedCauseName = Type.UNKNOWN.nameFunction.apply(cause);
            }
        }
    }

    public String getCauseType() {
        return this.cachedCauseType;
    }

    public String getCauseName() {
        return this.cachedCauseName;
    }

    public Set<String> findPotentialSources() {
        StackTraceElement[] stackTrace = this.error.getStackTrace();
        HashSet<String> modids = new HashSet<String>();
        for (StackTraceElement element : stackTrace) {
            URL resource;
            String modidFromResource;
            Class<?> clazz;
            try {
                clazz = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            String methodName = element.getMethodName();
            String modid = this.checkForMixin(clazz, methodName);
            if (modid != null) {
                modids.add(modid);
                continue;
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || (modidFromResource = TickingEntry.modidFromResource(resource = codeSource.getLocation())) == null) continue;
            modids.add(modidFromResource);
        }
        this.blacklistedModids.forEach(modids::remove);
        return modids;
    }

    @Nullable
    private String checkForMixin(Class<?> clazz, String methodName) {
        Method method = Reflection.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        if (!method.isAnnotationPresent(MixinMerged.class)) {
            return null;
        }
        MixinMerged annotation = method.getAnnotation(MixinMerged.class);
        String mixinClassName = annotation.mixin();
        ClassLoader classLoader = clazz.getClassLoader();
        URL resource = classLoader.getResource(mixinClassName.replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        return TickingEntry.modidFromResource(resource);
    }

    @Nullable
    private static String modidFromResource(URL resource) {
        String location = resource.getPath();
        int index = location.indexOf("jar");
        if (index != -1) {
            location = location.substring(0, index + "jar".length());
            String[] parts = location.split("/");
            String jarName = parts[parts.length - 1];
            return Platform.modidFromJar(jarName);
        }
        return null;
    }

    private static Throwable createThrowable(String message, String exceptionClass, StackTraceElement[] elements) {
        try {
            Class<?> clazz = Class.forName(exceptionClass);
            Throwable throwable = (Throwable)clazz.getConstructor(String.class).newInstance(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
        catch (Exception e) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isPersitent() {
        return this.persitent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TickingEntry that = (TickingEntry)obj;
        return Objects.equals(this.cachedCauseName, that.cachedCauseName) && Objects.equals(this.cachedCauseType, that.cachedCauseType) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    public String toString() {
        return "TickingEntry[causeType=%s, causeName=%s, dimension=%s pos=%s, uuid=%s, error=%s]".formatted(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    private record Type<T>(String type, Function<T, String> nameFunction) {
        static final Type<Entity> ENTITY = new Type<Entity>("Entity", entity -> entity.getName().getString());
        static final Type<BlockEntity> BLOCK_ENTITY = new Type<BlockEntity>("BlockEntity", blockEntity -> blockEntity.getBlockState().getBlock().getName().getString());
        static final Type<BlockState> BLOCK_STATE = new Type<BlockState>("BlockState", blockState -> blockState.getBlock().getName().getString());
        static final Type<ItemStack> ITEM_STACK = new Type<ItemStack>("ItemStack", itemStack -> itemStack.getItem().getName(itemStack).getString());
        static final Type<Object> UNKNOWN = new Type<Object>("Unknown", object -> "Unknown");
    }

    private record ThrowableData(String message, String exceptionClass, StackTraceElement[] elements) {
        public static final Codec<ThrowableData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("message").forGetter(throwableData -> Objects.requireNonNullElse(throwableData.message(), "")), (App)Codec.STRING.fieldOf("exceptionClass").forGetter(ThrowableData::exceptionClass), (App)StackTraceElementData.CODEC.listOf().fieldOf("elements").forGetter(ThrowableData::elementDatas)).apply((Applicative)instance, ThrowableData::new));

        private ThrowableData(String message, String exceptionClass, List<StackTraceElementData> elements) {
            this(message, exceptionClass, (StackTraceElement[])elements.stream().map(StackTraceElementData::toStackTraceElement).toArray(StackTraceElement[]::new));
        }

        public static ThrowableData fromThrowable(Throwable throwable) {
            return new ThrowableData(throwable.getMessage(), throwable.getClass().getName(), throwable.getStackTrace());
        }

        public Throwable toThrowable() {
            return TickingEntry.createThrowable(this.message, this.exceptionClass, this.elements);
        }

        public List<StackTraceElementData> elementDatas() {
            return Stream.of(this.elements).map(StackTraceElementData::fromStackTraceElement).toList();
        }

        private record StackTraceElementData(String classLoaderName, String moduleName, String moduleVersion, String declaringClass, String methodName, String fileName, int lineNumber) {
            public static final Codec<StackTraceElementData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("classLoaderName", (Object)"").forGetter(data -> Objects.requireNonNullElse(data.classLoaderName(), "")), (App)Codec.STRING.optionalFieldOf("moduleName", (Object)"").forGetter(data -> Objects.requireNonNullElse(data.moduleName(), "")), (App)Codec.STRING.optionalFieldOf("moduleVersion", (Object)"").forGetter(data -> Objects.requireNonNullElse(data.moduleVersion(), "")), (App)Codec.STRING.fieldOf("declaringClass").forGetter(StackTraceElementData::declaringClass), (App)Codec.STRING.fieldOf("methodName").forGetter(StackTraceElementData::methodName), (App)Codec.STRING.optionalFieldOf("fileName", (Object)"").forGetter(data -> Objects.requireNonNullElse(data.fileName(), "")), (App)Codec.INT.fieldOf("lineNumber").forGetter(StackTraceElementData::lineNumber)).apply((Applicative)instance, StackTraceElementData::new));

            public static StackTraceElementData fromStackTraceElement(StackTraceElement element) {
                return new StackTraceElementData(element.getClassLoaderName(), element.getModuleName(), element.getModuleVersion(), element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber());
            }

            public StackTraceElement toStackTraceElement() {
                return new StackTraceElement(this.classLoaderName.isEmpty() ? null : this.classLoaderName, this.moduleName.isEmpty() ? null : this.moduleName, this.moduleVersion.isEmpty() ? null : this.moduleVersion, this.declaringClass, this.methodName, this.fileName.isEmpty() ? null : this.fileName, this.lineNumber);
            }
        }
    }
}

