/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.exception.TickingException;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.client.ClientTickHandler;
import com.bawnorton.neruina.mixin.accessor.LevelChunkAccessor;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.MultiSetMap;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class TickHandler {
    private final List<TickingEntry> recentErrors = new ArrayList<TickingEntry>();
    private final Map<UUID, TickingEntry> tickingEntries = new HashMap<UUID, TickingEntry>();
    private final MultiSetMap<BlockState, BlockPos> erroredBlockStates = new MultiSetMap();
    private int stopwatch = 0;

    public void tick() {
        ++this.stopwatch;
        if (this.stopwatch >= 600) {
            if (!this.recentErrors.isEmpty()) {
                this.recentErrors.removeFirst();
            }
            this.stopwatch = 0;
        }
    }

    public void init() {
        this.tickingEntries.clear();
        this.recentErrors.clear();
    }

    public void safelyTickItemStack(ItemStack instance, Level level, Entity entity, EquipmentSlot slot, int slotIndex, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, level, entity, slot});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !level.isClientSide(), (Player)entity, slotIndex);
        }
    }

    public void safelyTickItemStack(ItemStack instance, Level level, Entity entity, int slot, boolean selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, level, entity, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !level.isClientSide(), (Player)entity, slot);
        }
    }

    public void safelyTickItemStack(ItemStack instance, Level level, Player player, int slot, int selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, level, player, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !level.isClientSide(), player, slot);
        }
    }

    public void safelyTickEntities(Consumer<Object> instance, Entity entity, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{instance, entity});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            this.preHandleTickingEntity(entity, e);
        }
    }

    public <T extends Entity> void safelyTickEntities(Consumer<T> consumer, T entity, Level level, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{consumer, entity, level, random});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            this.preHandleTickingEntity(entity, e);
        }
    }

    public void safelyTickPlayer(ServerPlayer instance, Operation<Void> original) {
        try {
            original.call(new Object[]{instance});
        }
        catch (Throwable e) {
            if (!Config.handleTickingPlayers.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_players", e);
            }
            this.handleTickingPlayer(instance, e);
        }
    }

    public void safelyTickBlockState(BlockState instance, ServerLevel level, BlockPos pos, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(instance, pos)) {
                return;
            }
            original.call(new Object[]{instance, level, pos, random});
        }
        catch (Throwable e) {
            if (!Config.handleTickingBlockStates.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_block_states", e);
            }
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)instance.getBlock());
            ResourceLocation owningBlacklist = this.getBlacklistFor(ErroredType.BLOCK_STATE, blockId);
            if (owningBlacklist != null) {
                throw TickingException.blacklisted(owningBlacklist, blockId, e);
            }
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            Component message = messageHandler.formatText("neruina.ticking.block_state", instance.getBlock().getName().getString(), messageHandler.posAsNums(pos));
            Neruina.LOGGER.warn("Neruina Caught An Exception, see below for cause", e);
            this.addErrored(instance, pos);
            TickingEntry tickingEntry = new TickingEntry(instance, true, (ResourceKey<Level>)level.dimension(), pos, e);
            this.trackError(tickingEntry);
            messageHandler.broadcastToPlayers(level.getServer(), message, forPlayer -> Texter.concatDelimited(Texter.LINE_BREAK, messageHandler.generateHandlingActions(forPlayer, ErroredType.BLOCK_STATE, (ResourceKey<Level>)level.dimension(), pos), messageHandler.generateResourceActions(forPlayer, tickingEntry)));
        }
    }

    public void safelyTickBlockEntity(BlockEntityTicker<? extends BlockEntity> instance, Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Operation<Void> original) {
        block6: {
            try {
                if (this.isErrored(blockEntity)) {
                    if (level.isClientSide()) {
                        return;
                    }
                    LevelChunk chunk = level.getChunkAt(pos);
                    ((LevelChunkAccessor)chunk).neruina$removeBlockEntityTicker(pos);
                    return;
                }
                original.call(new Object[]{instance, level, pos, state, blockEntity});
            }
            catch (Throwable e) {
                if (!Config.handleTickingBlockEntities.booleanValue()) {
                    throw TickingException.notHandled("handle_ticking_block_entities", e);
                }
                ResourceLocation blockEntityId = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType());
                ResourceLocation owningBlacklist = this.getBlacklistFor(ErroredType.BLOCK_ENTITY, blockEntityId);
                if (owningBlacklist != null) {
                    throw TickingException.blacklisted(owningBlacklist, blockEntityId, e);
                }
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                Component message = messageHandler.formatText("neruina.ticking.block_entity", state.getBlock().getName().getString(), messageHandler.posAsNums(pos));
                Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
                this.addErrored(blockEntity);
                if (level.isClientSide()) break block6;
                TickingEntry tickingEntry = new TickingEntry(blockEntity, true, (ResourceKey<Level>)level.dimension(), pos, e);
                this.trackError(blockEntity, tickingEntry);
                messageHandler.broadcastToPlayers(level.getServer(), message, forPlayer -> Texter.concatDelimited(Texter.LINE_BREAK, messageHandler.generateHandlingActions(forPlayer, ErroredType.BLOCK_ENTITY, (ResourceKey<Level>)level.dimension(), pos), messageHandler.generateResourceActions(forPlayer, tickingEntry)));
            }
        }
    }

    private void preHandleTickingEntity(Entity entity, Throwable e) {
        if (!Config.handleTickingEntities.booleanValue()) {
            throw TickingException.notHandled("handle_ticking_entities", e);
        }
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        ResourceLocation owningBlacklist = this.getBlacklistFor(ErroredType.ENTITY, entityId);
        if (owningBlacklist != null) {
            throw TickingException.blacklisted(owningBlacklist, entityId, e);
        }
        this.handleTickingEntity(entity, e);
    }

    private void handleTickingItemStack(Throwable e, ItemStack instance, boolean isServer, Player player, int slot) {
        if (!Config.handleTickingItemStacks.booleanValue()) {
            throw TickingException.notHandled("handle_ticking_item_stacks", e);
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)instance.getItem());
        ResourceLocation owningBlacklist = this.getBlacklistFor(ErroredType.ITEM_STACK, itemId);
        if (owningBlacklist != null) {
            throw TickingException.blacklisted(owningBlacklist, itemId, e);
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(instance);
        if (isServer) {
            TickingEntry tickingEntry = new TickingEntry(instance, false, (ResourceKey<Level>)player.level().dimension(), player.getOnPos(), e);
            this.trackError(instance, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            messageHandler.sendToPlayer(player, Texter.translatable("neruina.ticking.item_stack", instance.getHoverName().getString(), slot), messageHandler.generateResumeAction(player, ErroredType.ITEM_STACK, player.getStringUUID()), messageHandler.generateResourceActions(player, tickingEntry));
        }
    }

    private void handleErroredEntity(Entity entity) {
        try {
            if (entity instanceof Player) {
                return;
            }
            if (entity.level().isClientSide()) {
                return;
            }
            entity.baseTick();
            if (Config.autoKillTickingEntities.booleanValue() || !entity.isAlive()) {
                this.killEntity(entity, null);
            }
        }
        catch (Throwable e) {
            try {
                this.killEntity(entity, Neruina.getInstance().getMessageHandler().formatText("neruina.ticking.entity.suspend_failed", entity.getName().getString()));
            }
            catch (Throwable ex) {
                throw new TickingException("Exception occurred while handling errored entity", ex);
            }
        }
    }

    public void killEntity(Entity entity, @Nullable Component withMessage) {
        entity.kill();
        entity.remove(Entity.RemovalReason.KILLED);
        this.removeErrored(entity);
        if (withMessage != null) {
            Neruina.getInstance().getMessageHandler().broadcastToPlayers(entity.getServer(), withMessage);
        }
    }

    private void handleTickingEntity(Entity entity, Throwable e) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.handleTickingPlayer(serverPlayer, e);
            } else {
                this.handleTickingClient(player, e);
            }
            return;
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(entity);
        Level level = entity.level();
        if (!level.isClientSide()) {
            BlockPos pos = entity.getOnPos();
            TickingEntry tickingEntry = new TickingEntry(entity, true, (ResourceKey<Level>)level.dimension(), pos, e);
            this.trackError(entity, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            Component message = messageHandler.formatText("neruina.ticking.entity.%s".formatted(Config.autoKillTickingEntities != false ? "killed" : "suspended"), entity.getName().getString(), messageHandler.posAsNums(pos));
            messageHandler.broadcastToPlayers(entity.getServer(), message, forPlayer -> {
                Component actions = messageHandler.generateResourceActions(forPlayer, tickingEntry);
                if (!Config.autoKillTickingEntities.booleanValue()) {
                    actions = Texter.concatDelimited(Texter.LINE_BREAK, messageHandler.generateEntityActions(forPlayer, entity), actions);
                }
                return actions;
            });
        }
    }

    private void handleTickingPlayer(ServerPlayer player, Throwable e) {
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        MinecraftServer server = player.getServer();
        String name = player.getDisplayName().getString();
        MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
        Component message = messageHandler.formatText("neruina.ticking.player", name);
        TickingEntry tickingEntry = new TickingEntry(player, false, (ResourceKey<Level>)player.level().dimension(), player.getOnPos(), e);
        this.trackError(tickingEntry);
        messageHandler.broadcastToPlayers(server, message, forPlayer -> messageHandler.generateResourceActions(forPlayer, tickingEntry));
        try {
            player.connection.disconnect(Texter.concat(Texter.translatable("neruina.kick.message", new Object[0]), Texter.translatable("neruina.kick.reason", new Object[0])));
        }
        catch (NullPointerException ex) {
            Neruina.LOGGER.error("Neruina caught an exception on a player, but the player is not connected, this should not happen. Behaviour is undefined.", (Throwable)ex);
        }
    }

    private void handleTickingClient(Player player, Throwable e) {
        if (player.level().isClientSide() || Platform.isClient()) {
            ClientTickHandler.handleTickingClient(player, e);
        } else {
            Neruina.LOGGER.error("Neruina caught an exception, but the player is not a server player, this should not happen. Behaviour is undefined.", e);
        }
    }

    private void trackError(TickingEntry entry) {
        this.trackError(null, entry);
    }

    private void trackError(Object object, TickingEntry entry) {
        if (object instanceof Errorable) {
            Errorable errorable = (Errorable)object;
            this.trackError(errorable, entry);
        } else if (object == null) {
            this.trackError(null, entry);
        }
    }

    private void trackError(@Nullable Errorable errorable, TickingEntry entry) {
        this.recentErrors.add(entry);
        this.addTickingEntry(entry);
        if (errorable != null) {
            errorable.neruina$setTickingEntryId(entry.uuid());
        }
        if (Config.tickingExceptionThreshold != -1 && this.recentErrors.size() >= Config.tickingExceptionThreshold) {
            CrashReport report = CrashReport.forThrowable((Throwable)new RuntimeException("Too Many Ticking Exceptions"), (String)"Neruina has caught too many ticking exceptions in a short period of time, something is very wrong, see below for more info");
            CrashReportCategory header = report.addCategory("Information");
            header.setDetail("Threshold", (Object)"%d, set \"ticking_exception_threshold\" to -1 to disable.".formatted(Config.tickingExceptionThreshold));
            header.setDetail("Caught", (Object)this.recentErrors.size());
            String wiki = "https://github.com/Bawnorton/Neruina/wiki/Too-Many-Ticking-Exceptions";
            String lines = "=".repeat(wiki.length() + "Wiki".length() + 2);
            header.setDetail("", (Object)lines);
            header.setDetail("Wiki", (Object)wiki);
            header.setDetail("", (Object)lines);
            for (int i = 0; i < this.recentErrors.size(); ++i) {
                TickingEntry error = this.recentErrors.get(i);
                CrashReportCategory category = report.addCategory("Ticking Exception #%s - (%s: %s)".formatted(i + 1, error.getCauseType(), error.getCauseName()));
                error.populate(category);
            }
            throw new ReportedException(report);
        }
    }

    public boolean isErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            return errorable.neruina$isErrored();
        }
        return false;
    }

    public boolean isErrored(BlockState state, BlockPos pos) {
        return this.erroredBlockStates.contains(state, pos);
    }

    private void addErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$setErrored();
        }
    }

    private void addErrored(BlockState state, BlockPos pos) {
        this.erroredBlockStates.put(state, pos);
    }

    public void removeErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$clearErrored();
            this.tickingEntries.remove(errorable.neruina$getTickingEntryId());
        }
    }

    public void removeErrored(BlockState state, BlockPos pos) {
        this.erroredBlockStates.remove(state, pos);
    }

    @Nullable
    public TickingEntry getTickingEntry(UUID uuid) {
        return this.tickingEntries.get(uuid);
    }

    public Collection<TickingEntry> getTickingEntries() {
        return this.tickingEntries.values();
    }

    public void addTickingEntry(TickingEntry entry) {
        Object cause = entry.getCause();
        boolean shouldAdd = false;
        if (this.isErrored(cause)) {
            shouldAdd = true;
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            shouldAdd = this.isErrored(state, entry.pos());
        }
        if (shouldAdd) {
            this.tickingEntries.put(entry.uuid(), entry);
        }
    }

    public void addTickingEntryUnsafe(TickingEntry entry) {
        this.tickingEntries.put(entry.uuid(), entry);
    }

    public Optional<UUID> getTickingEntryId(Object obj) {
        Errorable errorable;
        if (obj instanceof Errorable && (errorable = (Errorable)obj).neruina$isErrored()) {
            return Optional.ofNullable(errorable.neruina$getTickingEntryId());
        }
        return Optional.empty();
    }

    public int clearTracked() {
        int size = this.tickingEntries.size();
        this.tickingEntries.clear();
        this.recentErrors.clear();
        return size;
    }

    private ResourceLocation getBlacklistFor(ErroredType type, ResourceLocation id) {
        return Neruina.getInstance().getBlacklistHandler().getBlacklistFor(type, id);
    }
}

