/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RemoveEntityMessage(ResourceKey<Level> worldRegistryKey, UUID uuid, boolean tile, boolean force) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveEntityMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("removeentitymessage"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveEntityMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), RemoveEntityMessage::worldRegistryKey, (StreamCodec)UUIDUtil.STREAM_CODEC, RemoveEntityMessage::uuid, (StreamCodec)ByteBufCodecs.BOOL, RemoveEntityMessage::tile, (StreamCodec)ByteBufCodecs.BOOL, RemoveEntityMessage::force, RemoveEntityMessage::new);

    public static boolean handle(RemoveEntityMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (!player.hasPermissions(2)) {
            return true;
        }
        if (data.tile) {
            WorldUtils.removeTileEntity((Level)player.getServer().getLevel(data.worldRegistryKey), data.uuid, data.force);
        } else {
            WorldUtils.removeEntity((Level)player.getServer().getLevel(data.worldRegistryKey), data.uuid);
        }
        return true;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

