/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.level.Level;

public class ActivityCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.asList("week", "day", "month"), (SuggestionsBuilder)builder);

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"activity").executes(ActivityCommand::listActivity)).then(Commands.argument((String)"time", (ArgumentType)StringArgumentType.word()).suggests(sugg).executes(ctx -> ActivityCommand.listActivityByDate((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"time"))));
    }

    private static int listActivity(CommandContext<CommandSourceStack> context) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSourceStack)context.getSource()).getLevel());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Number of Players active in the last:"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Day: " + history.getDay().size() + " unique players"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Week: " + history.getWeek().size() + " unique players"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Month: " + history.getMonth().size() + " unique players"), false);
        return 1;
    }

    private static int listActivityByDate(CommandContext<CommandSourceStack> context, String time) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSourceStack)context.getSource()).getServer().getLevel(Level.OVERWORLD));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Active Players in the last " + time), false);
        StringBuilder b = new StringBuilder();
        switch (time) {
            case "month": {
                history.getMonth().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "week": {
                history.getWeek().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "day": {
                history.getDay().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent(b.toString()), false);
        return 1;
    }
}

