/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import teamdraco.unnamedanimalmod.config.UAMConfig;
import teamdraco.unnamedanimalmod.data.providers.UAMBlockTagsProvider;
import teamdraco.unnamedanimalmod.data.providers.UAMItemTagsProvider;
import teamdraco.unnamedanimalmod.entity.CapybaraAnimalAttractionGoal;
import teamdraco.unnamedanimalmod.registry.EntityRegistry;
import teamdraco.unnamedanimalmod.registry.SoundRegistry;

public class Capybara
extends TamableAnimal
implements MenuProvider {
    public static final EntityDimensions BABY_DIMENSIONS = ((EntityType)EntityRegistry.CAPYBARA.get()).getDimensions().scale(0.5f).withEyeHeight(0.5f);
    public static final EntityDataAccessor<Integer> CHESTS = SynchedEntityData.defineId(Capybara.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected SimpleContainer inventory;

    public Capybara(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(UAMItemTagsProvider.CAPYBARA_FOOD), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new CapybaraAnimalAttractionGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHESTS, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public static boolean checkCapybaraSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(UAMBlockTagsProvider.CAPYBARAS_SPAWN_ON) && Capybara.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected float getBlockSpeedFactor() {
        return 0.65f;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(Items.MELON);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CAPYBARA_AMBIENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.CAPYBARA_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CAPYBARA_DEATH.value();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 1.0f);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source) || source.getEntity() == this.getOwner()) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!this.level().isClientSide) {
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.heal(item.getFoodProperties(stack, (LivingEntity)player).nutrition());
                return InteractionResult.SUCCESS;
            }
            if (player.isCrouching() && !this.isBaby()) {
                if (stack.getItem() == Blocks.CHEST.asItem() && this.isTame()) {
                    if (this.inventory == null || this.inventory.getContainerSize() < 27) {
                        this.inventory = new SimpleContainer(27);
                        this.entityData.set(CHESTS, (Object)1);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (this.inventory.getContainerSize() < 54) {
                        SimpleContainer inv = new SimpleContainer(54);
                        for (int i = 0; i < 27; ++i) {
                            inv.setItem(i, this.inventory.getItem(i));
                        }
                        this.inventory = inv;
                        this.entityData.set(CHESTS, (Object)2);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (stack.getItem() == Items.STICK && !this.isBaby()) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (stack.is(UAMItemTagsProvider.CAPYBARA_FOOD) && !this.isTame()) {
                    if (this.random.nextInt(3) == 0) {
                        this.tame(player);
                        this.navigation.stop();
                        this.setTarget(null);
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    }
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!this.isBaby() && this.isTame()) {
                    player.openMenu((MenuProvider)this);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)EntityRegistry.CAPYBARA.get()).create((Level)serverLevel);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public void tick() {
        super.tick();
        this.floatStrider();
        this.checkInsideBlocks();
        if (((Boolean)UAMConfig.capybaraAttractionGoal.get()).booleanValue() && this.getPassengers().isEmpty()) {
            for (Entity e : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5))) {
                if (!(e instanceof Mob) || !(e.getBbWidth() <= 0.75f) || !((double)e.getBbHeight() <= 0.75) || this.isBaby() || e.getClassification(false) == MobCategory.WATER_CREATURE || this.isInWater()) continue;
                e.startRiding((Entity)this);
            }
        } else if (this.isInWater()) {
            this.ejectPassengers();
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterPathNavigator((Mob)this, level);
    }

    private void floatStrider() {
        if (this.isUnderWater()) {
            CollisionContext shapeContext = CollisionContext.of((Entity)this);
            if (shapeContext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.WATER)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Chests", this.getChestCount());
        if (this.getChestCount() > 0) {
            ListTag listtag = new ListTag();
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                listtag.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag));
            }
            compound.put("Items", (Tag)listtag);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setChests(compound.getInt("Chests"));
        this.createInventory();
        if (this.getChestCount() > 0) {
            ListTag listtag = compound.getList("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j >= this.inventory.getContainerSize()) continue;
                this.inventory.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
        }
    }

    public AbstractContainerMenu createMenu(int i, Inventory inv, Player player) {
        if (this.inventory == null) {
            return null;
        }
        return this.inventory.getContainerSize() < 54 ? ChestMenu.threeRows((int)i, (Inventory)inv, (Container)this.inventory) : ChestMenu.sixRows((int)i, (Inventory)inv, (Container)this.inventory);
    }

    public int getChestCount() {
        return (Integer)this.entityData.get(CHESTS);
    }

    public void setChests(int chests) {
        this.entityData.set(CHESTS, (Object)chests);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getChestCount() == 2 ? 54 : 27);
        if (simplecontainer != null) {
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.getChestCount() > 0 && !this.level().isClientSide()) {
            for (int c = 0; c < this.getChestCount(); ++c) {
                this.spawnAtLocation((ItemLike)Blocks.CHEST);
            }
            if (this.inventory != null) {
                for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                    ItemStack stack = this.inventory.getItem(i);
                    if (stack.isEmpty()) continue;
                    this.spawnAtLocation(stack);
                }
            }
        }
    }

    static class WaterPathNavigator
    extends GroundPathNavigation {
        public WaterPathNavigator(Mob mob, Level level) {
            super(mob, level);
        }

        protected PathFinder createPathFinder(int maxVisitedNodes) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
        }

        protected boolean hasValidPathType(PathType pathType) {
            return pathType == PathType.WATER || super.hasValidPathType(pathType);
        }

        public boolean isStableDestination(BlockPos pos) {
            return this.level.getBlockState(pos).is(Blocks.WATER) || super.isStableDestination(pos);
        }
    }
}

