/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.sap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class SapCollectionParticleEffect
extends MalumNetworkedParticleEffectType<SapCollectionEffectData> {
    public SapCollectionParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(SapCollectionEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, SapCollectionEffectData extraData) {
        Direction direction = extraData.direction;
        Player player = level.getPlayerByUUID(extraData.playerUUID);
        BlockPos blockPos = positionData.getAsBlockPos();
        Vec3 pos = blockPos.getCenter().relative(direction, 0.5);
        Vec3i normal = direction.getNormal();
        float yRot = (float)(Mth.atan2((double)normal.getX(), (double)normal.getZ()) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        Vec3 up = left.cross(new Vec3((double)normal.getX(), (double)normal.getY(), (double)normal.getZ()));
        Consumer<LodestoneWorldParticle> acceleration = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)1.2f));
        for (int i = 0; i < 12; ++i) {
            float leftOffset = (random.nextFloat() - 0.5f) * 0.75f;
            float upOffset = (random.nextFloat() - 0.5f) * 0.75f;
            Vec3 particlePosition = pos.add(left.scale((double)leftOffset)).add(up.scale((double)upOffset));
            Vec3 particleMotion = player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0).subtract(particlePosition).normalize();
            Vec3 targetPosition = pos.add(particleMotion.scale(0.75));
            Vec3 actualMotion = targetPosition.subtract(particlePosition).normalize().scale((double)0.01f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, colorData.getColor());
            lightSpecs.getBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
        }
    }

    public record SapCollectionEffectData(Direction direction, UUID playerUUID) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<SapCollectionEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Direction.CODEC.fieldOf("direction").forGetter(SapCollectionEffectData::direction), (App)UUIDUtil.CODEC.fieldOf("playerUUID").forGetter(SapCollectionEffectData::playerUUID)).apply((Applicative)instance, SapCollectionEffectData::new));
        public static final StreamCodec<ByteBuf, SapCollectionEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

