/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.pylon;

import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonCoreBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.visual_effects.RepairPylonParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import com.sammy.malum.visual_effects.networked.pylon.PylonEffectData;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public class PylonRepairParticleEffect
extends MalumNetworkedParticleEffectType<PylonEffectData> {
    public PylonRepairParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(PylonEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, PylonEffectData extraData) {
        BlockEntity blockEntity = level.getBlockEntity(positionData.getAsBlockPos());
        if (!(blockEntity instanceof RepairPylonCoreBlockEntity)) {
            return;
        }
        RepairPylonCoreBlockEntity pylon = (RepairPylonCoreBlockEntity)blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(extraData.holderPos());
        if (!(blockEntity2 instanceof IMalumSpecialItemAccessPoint)) {
            return;
        }
        IMalumSpecialItemAccessPoint holder = (IMalumSpecialItemAccessPoint)blockEntity2;
        RepairPylonParticleEffects.repairItemParticles(pylon, holder, colorData);
    }
}

