/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.nitrate;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.nitrate.NitrateImpactParticleEffectType;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class EthericNitrateImpactParticleEffect
extends NitrateImpactParticleEffectType {
    public EthericNitrateImpactParticleEffect(String id) {
        super(id);
    }

    @Override
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectExtraData extraData) {
        double posX = positionData.getPosX();
        double posY = positionData.getPosY();
        double posZ = positionData.getPosZ();
        Vec3 pos = new Vec3(posX, posY, posZ);
        for (int i = 0; i < 16; ++i) {
            ColorParticleData color = colorData.getColor();
            float lifetimeMultiplier = RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)1.5f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f);
            double horizontalAngle = random.nextDouble() * Math.PI * 2.0;
            double x = Math.cos(horizontalAngle);
            double y = Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f);
            double z = Math.sin(horizontalAngle);
            Vec3 direction = new Vec3(x, y, z);
            Vec3 motion = direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)3.0f));
            Vec3 spawnPosition = pos.add(direction.scale(0.25));
            Consumer<LodestoneWorldParticle> sparkBehavior = p -> {
                Vec3 velocity = p.getParticleSpeed().scale(0.75);
                if (velocity.equals((Object)Vec3.ZERO)) {
                    velocity = p.getParticleSpeed();
                }
                p.setParticleSpeed(velocity.x, (velocity.y - (double)gravityStrength) * (double)0.98f, velocity.z);
                if ((float)p.getAge() < (float)p.getLifetime() * 0.7f && level.getGameTime() % 2L == 0L) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, p.getParticlePosition(), p.colorData);
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier / 2.0f).enableForcedSpawn();
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier / 4.0f);
                    lightSpecs.spawnParticles();
                }
            };
            float scalar = RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.1f);
            ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, color).act(b -> b.getParticleOptions().setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()));
            sparks.getBuilder().setLengthData(GenericParticleData.create((float)(3.0f * scalar), (float)(0.75f * scalar), (float)0.0f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).build()).multiplyLifetime(lifetimeMultiplier).addTickActor(sparkBehavior).enableForcedSpawn().setMotion(motion);
            sparks.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).multiplyLifetime(lifetimeMultiplier).addTickActor(sparkBehavior).setMotion(motion);
            sparks.spawnParticles();
        }
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build();
        float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
        WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.GIANT_GLOWING_STAR.get())).setTransparencyData(GenericParticleData.create((float)0.9f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(15).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(5.0f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData(colorData.getColor()).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).repeat(level, posX, posY, posZ, 3);
    }
}

