/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class TyrvingSlashParticleEffect
extends MalumNetworkedWeaponParticleEffectType<WeaponParticleEffectType.WeaponParticleEffectData> {
    public TyrvingSlashParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WeaponParticleEffectType.WeaponParticleEffectData extraData) {
        float offsetBase = RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)0.8f) * (float)(random.nextBoolean() ? 1 : -1) + (extraData.isMirrored() ? 3.14f : 0.0f);
        for (int i = 0; i < 8; ++i) {
            ParticleEffectSpawner slash;
            if (i >= 6) {
                slash = WeaponParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), MalumParticles.SLASH, ColorParticleData.create((float)0.15f, (float)0.05f, (float)0.1f).build());
                slash.getBuilder().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TRANSPARENT);
            } else {
                slash = WeaponParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), MalumParticles.SLASH, colorData);
            }
            Vec3 direction = extraData.getDirection();
            float spinOffset = extraData.getSlashRotation() + (float)(i % 2 == 0 ? 1 : -1) * offsetBase;
            int lifeDelay = i % 2 == 0 ? 3 : 0;
            slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)).build()).setMotion(direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)0.7f))).setLifeDelay(lifeDelay).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)direction));
            slash.spawnParticles();
        }
    }
}

