/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class SunderingAnchorSlashParticleEffect
extends MalumNetworkedWeaponParticleEffectType<SunderingAnchorSlashEffectData> {
    public SunderingAnchorSlashParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(SunderingAnchorSlashEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, SunderingAnchorSlashEffectData extraData) {
        int slashCount = extraData.slashCount;
        for (int i = 0; i < slashCount; ++i) {
            float spinOffset = extraData.getSlashRotation() + RandomHelper.randomBetween((RandomSource)random, (float)-3.14f, (float)3.14f) + (extraData.isMirrored() ? 3.14f : 0.0f);
            Vec3 direction = extraData.getDirection();
            for (int j = 0; j < 2; ++j) {
                ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), MalumParticles.THIN_SLASH, colorData);
                int lifeDelay = (i + j) * 2;
                slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)).build()).setMotion(direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.3f))).setLifeDelay(lifeDelay).setLifetime(4).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)direction));
                slash.spawnParticles();
            }
        }
    }

    public static class SunderingAnchorSlashEffectData
    extends WeaponParticleEffectType.WeaponParticleEffectData {
        public static final Codec<SunderingAnchorSlashEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("direction").forGetter(WeaponParticleEffectType.WeaponParticleEffectData::getDirection), (App)Codec.BOOL.fieldOf("mirror").forGetter(WeaponParticleEffectType.WeaponParticleEffectData::isMirrored), (App)Codec.FLOAT.fieldOf("slashRotation").forGetter(WeaponParticleEffectType.WeaponParticleEffectData::getSlashRotation), (App)Codec.INT.fieldOf("slashCount").forGetter(SunderingAnchorSlashEffectData::slashCount)).apply((Applicative)instance, SunderingAnchorSlashEffectData::new));
        public static final StreamCodec<ByteBuf, SunderingAnchorSlashEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        public final int slashCount;

        public SunderingAnchorSlashEffectData(Vec3 direction, boolean isMirrored, float slashRotation, int slashCount) {
            super(direction, isMirrored, slashRotation);
            this.slashCount = slashCount;
        }

        public SunderingAnchorSlashEffectData(int slashCount) {
            super(Vec3.ZERO, false, 0.0f);
            this.slashCount = slashCount;
        }

        public int slashCount() {
            return this.slashCount;
        }

        public WeaponParticleEffectType.WeaponParticleEffectData modify(Vec3 direction, boolean isMirrored, float slashRotation) {
            return new SunderingAnchorSlashEffectData(direction, isMirrored, slashRotation, this.slashCount);
        }
    }
}

