/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class HiddenBladeCounterParticleEffect
extends MalumNetworkedWeaponParticleEffectType<WeaponParticleEffectType.WeaponParticleEffectData> {
    public HiddenBladeCounterParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WeaponParticleEffectType.WeaponParticleEffectData extraData) {
        float maxBackwardsOffset = 1.5f;
        float maxForwardsOffset = 4.5f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 100; ++j) {
                Vec3 direction = extraData.getDirection();
                float offsetBase = RandomHelper.randomBetween((RandomSource)random, (float)0.314f, (float)3.14f) * (float)(random.nextBoolean() ? 1 : -1) + (extraData.isMirrored() ? 3.14f : 0.0f);
                float spinOffset = extraData.getSlashRotation() + (float)(j % 2 == 0 ? 1 : -1) * offsetBase;
                float scale = RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)6.0f);
                int lifeDelay = (j % 2 == 0 ? 2 : 0) + i + j / 6;
                Vec3 position = positionData.getAsVector().add(direction.multiply((double)RandomHelper.randomBetween((RandomSource)random, (float)-1.5f, (float)4.5f), (double)RandomHelper.randomBetween((RandomSource)random, (float)-1.5f, (float)4.5f), (double)RandomHelper.randomBetween((RandomSource)random, (float)-1.5f, (float)4.5f)));
                ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, position, random.nextBoolean() ? MalumParticles.SLASH : MalumParticles.THIN_SLASH, colorData);
                slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)scale).build()).setMotion(direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.5f))).setLifeDelay(lifeDelay).setLifetime(2 + i).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)direction));
                slash.spawnParticles();
            }
        }
    }
}

