/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class WeepingWellParticleEffects {
    private static final VoxelShape WELL_SHAPE = Block.box((double)-16.0, (double)4.0, (double)-16.0, (double)32.0, (double)5.0, (double)32.0);
    private static final VoxelShape DEPOT_SHAPE = Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final GenericParticleData SMOKE_TRANSPARENCY = GenericParticleData.create((float)0.5f, (float)1.0f, (float)0.2f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build();

    public static Color getWeepingWellSmokeColor(RandomSource rand) {
        float colorMultiplier = RandomHelper.randomBetween((RandomSource)rand, (float)0.6f, (float)1.2f);
        return new Color((int)(12.0f * colorMultiplier), (int)(3.0f * colorMultiplier), (int)(12.0f * colorMultiplier));
    }

    public static void spitOutItemParticles(Level level, NetworkedParticleEffectPositionData positionEffectData) {
        int i;
        double posX = positionEffectData.getPosX();
        double posY = positionEffectData.getPosY();
        double posZ = positionEffectData.getPosZ();
        Vec3 pos = new Vec3(posX, posY, posZ);
        RandomSource rand = level.random;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        Consumer<LodestoneWorldParticle> spawnBehavior = p -> p.tick(2);
        for (int i2 = 0; i2 < 64; ++i2) {
            float xVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.0f, (float)0.15f) * (float)(rand.nextBoolean() ? 1 : -1);
            float yVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)1.0f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.0f, (float)0.15f) * (float)(rand.nextBoolean() ? 1 : -1);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)rand, (float)0.75f, (float)1.0f);
            if (rand.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
                sparkParticles.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                sparkParticles.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(rand.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
            lightSpecs.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = rand.nextInt(360);
        for (i = 0; i < 4; ++i) {
            int spinDirection = rand.nextBoolean() ? 1 : -1;
            float scaleMultiplier = (float)(1.0 + Math.pow(rand.nextFloat(), 2.0));
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.7f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + rand.nextFloat() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)(2.4f * scaleMultiplier), (float)0.8f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).setColorData(colorData).setLifetime(25).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat(level, posX, posY + 0.25, posZ, 5);
        }
        for (i = 0; i < 8; ++i) {
            int finalI = 4 + i / 2;
            ParticleEffectSpawner squares = WeepingWellParticleEffects.weepingWellSquare(level, pos, colorData);
            squares.getBuilder().multiplyLifetime(0.5f).addSpawnActor(p -> p.tick(finalI));
            squares.spawnParticles();
        }
    }

    public static void passiveWeepingWellParticles(VoidConduitBlockEntity voidConduit) {
        Level level = voidConduit.getLevel();
        if (level.getGameTime() % 6L == 0L) {
            BlockPos blockPos = voidConduit.getBlockPos();
            RandomSource rand = level.random;
            int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)80, (int)120);
            float yMotion = 0.004f;
            Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
            ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.WISP_PARTICLE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.02f, (float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.3f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setColorData(colorData).setLifetime(lifetime).addMotion(0.0, (double)yMotion, 0.0).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).surroundVoxelShape(level, blockPos, WELL_SHAPE, 12);
            for (int i = 0; i < 4; ++i) {
                Direction direction = Direction.from2DDataValue((int)i);
                Vec3 offset = new Vec3((double)((float)direction.getStepX() * 1.48f), 0.0, (double)((float)direction.getStepZ() * 1.48f));
                Vec3 offsetPosition = new Vec3((double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.5f), (double)((float)blockPos.getZ() + 0.5f)).add(offset);
                WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.WISP_PARTICLE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)offset)).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)3.0f, (float)0.3f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setLengthData(GenericParticleData.create((float)0.0f, (float)2.0f, (float)0.3f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setColorData(ColorParticleData.create((float)0.0f, (float)0.0f, (float)0.0f).build()).setLifetime(80).addMotion(0.0, (double)yMotion, 0.0).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).spawn(level, offsetPosition.x, offsetPosition.y, offsetPosition.z);
            }
            if (rand.nextFloat() < 0.75f) {
                int rotation = rand.nextInt(16);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)new Vec3((double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.75f), (double)((float)blockPos.getZ() + 0.5f)), (float)1.1f, (float)rotation, (float)16.0f, (float)level.getGameTime(), (float)640.0f);
                float acceleration = RandomHelper.randomBetween((RandomSource)rand, (float)0.002f, (float)0.02f);
                long gameTime = level.getGameTime();
                Consumer<LodestoneWorldParticle> behavior = p -> {
                    if (level.getGameTime() < gameTime + 10L) {
                        p.setParticleSpeed(p.getParticleSpeed().add(0.0, (double)acceleration, 0.0));
                    }
                };
                for (int i = 0; i < 2; ++i) {
                    ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition);
                    lightSpecs.getBuilder().addTickActor(behavior);
                    lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.getBloomBuilder().addTickActor(behavior);
                    lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static void passiveVoidDepotParticles(VoidDepotBlockEntity voidDepot) {
        Level level = voidDepot.getLevel();
        if (level.getGameTime() % 60L == 0L) {
            BlockPos blockPos = voidDepot.getBlockPos();
            RandomSource rand = level.random;
            int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)80, (int)120);
            float yMotion = 5.0E-4f;
            Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
            ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.WISP_PARTICLE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.02f, (float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)0.2f, (float)0.05f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setColorData(colorData).setLifetime(lifetime).addMotion(0.0, (double)yMotion, 0.0).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).surroundVoxelShape(level, blockPos, DEPOT_SHAPE, 4);
            if (rand.nextFloat() < 0.2f) {
                int rotation = rand.nextInt(16);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)new Vec3((double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.75f), (double)((float)blockPos.getZ() + 0.5f)), (float)0.5f, (float)rotation, (float)16.0f, (float)level.getGameTime(), (float)640.0f);
                float acceleration = RandomHelper.randomBetween((RandomSource)rand, (float)0.002f, (float)0.02f);
                long gameTime = level.getGameTime();
                Consumer<LodestoneWorldParticle> behavior = p -> {
                    if (level.getGameTime() < gameTime + 4L) {
                        p.setParticleSpeed(p.getParticleSpeed().add(0.0, (double)acceleration, 0.0));
                    }
                };
                for (int i = 0; i < 2; ++i) {
                    ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition);
                    lightSpecs.getBuilder().addTickActor(behavior);
                    lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.getBloomBuilder().addTickActor(behavior);
                    lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static ParticleEffectSpawner weepingWellSparks(Level level, Vec3 pos) {
        RandomSource rand = level.random;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        return WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
    }

    public static ParticleEffectSpawner weepingWellSparks(Level level, Vec3 pos, ColorParticleData colorData, LodestoneWorldParticleRenderType renderType) {
        RandomSource rand = level.random;
        ParticleEffectSpawner lightSpecs = SparkParticleEffects.spiritMotionSparks(level, pos, colorData);
        lightSpecs.getBuilder().setRenderType((ParticleRenderType)renderType).multiplyLifetime(6.0f).modifyData(AbstractParticleBuilder::getLengthData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)1.75f, (float)2.5f))).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)0.75f, (float)1.0f))).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)3.5f)));
        lightSpecs.getBloomBuilder().setRenderType((ParticleRenderType)renderType).multiplyLifetime(6.0f).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.75f, (float)0.25f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)1.0f, (float)1.25f)));
        return lightSpecs;
    }

    public static ParticleEffectSpawner weepingWellSpecs(Level level, Vec3 pos) {
        RandomSource rand = level.random;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        return WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
    }

    public static ParticleEffectSpawner weepingWellSpecs(Level level, Vec3 pos, ColorParticleData colorData, LodestoneWorldParticleRenderType renderType) {
        RandomSource rand = level.random;
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, colorData, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC_SMALL.get()));
        lightSpecs.getBuilder().act(b -> b.setRenderType((ParticleRenderType)renderType).multiplyLifetime(6.0f).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)0.75f, (float)1.0f))).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)3.5f))));
        lightSpecs.getBloomBuilder().act(b -> b.setRenderType((ParticleRenderType)renderType).multiplyLifetime(6.0f).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.75f, (float)0.25f).build()).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)rand, (float)1.0f, (float)1.25f))));
        return lightSpecs;
    }

    public static ParticleEffectSpawner weepingWellSquare(Level level, Vec3 pos, ColorParticleData colorData) {
        RandomSource rand = level.random;
        GenericParticleData scaleData = GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)1.7f, (float)1.8f), (float)0.5f).setEasing(Easing.SINE_OUT, Easing.SINE_IN).setCoefficient(RandomHelper.randomBetween((RandomSource)rand, (float)1.0f, (float)1.25f)).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        float yMotion = RandomHelper.randomBetween((RandomSource)rand, (float)0.04f, (float)0.06f);
        Vec3 motion = new Vec3(0.0, (double)yMotion, 0.0);
        WorldParticleBuilder squares = WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.SQUARE.get())).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setTransparencyData(GenericParticleData.create((float)0.9f, (float)0.05f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.EXPO_IN).build()).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setScaleData(scaleData).setColorData(colorData).addTickActor(behavior).setMotion(motion).setLifetime(100).enableNoClip();
        Consumer<WorldParticleBuilder> squareSpawner = b -> b.spawn(level, pos.x, pos.y, pos.z).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.EXPO_OUT).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, pos.x, pos.y, pos.z);
        return new ParticleEffectSpawner(squares, squareSpawner);
    }
}

