/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.common.entity.scythe.AbstractScytheProjectileEntity;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class WeaponParticleEffects {
    public static final PointyDirectionalParticleBehavior MAELSTROM_DIRECTION = PointyDirectionalParticleBehavior.pointyDirectional((Vec3)new Vec3(0.0, 0.0, 0.0));

    public static void spawnMaelstromParticles(AbstractScytheProjectileEntity entity) {
        Level level = entity.level();
        if (level.getGameTime() % 2L == 0L) {
            MalumSpiritType malumSpiritType;
            RandomSource random = level.getRandom();
            Item item = entity.getItem().getItem();
            if (item instanceof ISpiritAffiliatedItem) {
                ISpiritAffiliatedItem spiritItem = (ISpiritAffiliatedItem)item;
                malumSpiritType = spiritItem.getDefiningSpiritType();
            } else {
                malumSpiritType = null;
            }
            MalumSpiritType spirit = malumSpiritType;
            ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, entity.position(), MalumParticles.ROUNDABOUT_SLASH, spirit);
            float spinOffset = RandomHelper.randomBetween((RandomSource)random, (float)-0.8f, (float)0.8f);
            int age = RandomHelper.randomBetween((RandomSource)random, (int)8, (int)18);
            slash.getBuilder().setBehavior((LodestoneParticleBehavior)MAELSTROM_DIRECTION).setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.5f, (float)3.0f)).build()).setTransparencyData(GenericParticleData.create((float)0.9f, (float)0.6f).build()).addTickActor(p -> p.setParticlePosition(entity.position())).setLifetime(age);
            slash.spawnParticles();
            slash.getBuilder().setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.3f).build()).setLifeDelay(6);
            slash.spawnParticles();
            slash.getBuilder().setTransparencyData(GenericParticleData.create((float)0.3f, (float)0.0f).build()).setLifeDelay(12);
            slash.spawnParticles();
        }
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, MalumNetworkedParticleEffectColorData color) {
        if (color == null) {
            return WeaponParticleEffects.spawnSlashParticle(level, pos, particleType);
        }
        if (color.isSpiritBased()) {
            return WeaponParticleEffects.spawnSlashParticle(level, pos, particleType, color.getSpirit());
        }
        return WeaponParticleEffects.spawnSlashParticle(level, pos, particleType, color.getColor());
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, MalumSpiritType spiritType) {
        if (spiritType == null) {
            return WeaponParticleEffects.spawnSlashParticle(level, pos, particleType);
        }
        return WeaponParticleEffects.spawnSlashParticle(level, pos, SpiritBasedParticleBuilder.createSpirit(particleType.get()).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, ColorParticleData colorData) {
        return WeaponParticleEffects.spawnSlashParticle(level, pos, WorldParticleBuilder.create((LodestoneWorldParticleType)particleType.get()).setColorData(colorData));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType) {
        return WeaponParticleEffects.spawnSlashParticle(level, pos, WorldParticleBuilder.create(particleType).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TRANSPARENT).setColorData(ColorParticleData.createGrayParticleColor((RandomSource)level.random)));
    }

    public static ParticleEffectSpawner spawnSlashParticle(Level level, Vec3 pos, WorldParticleBuilder builder) {
        RandomSource rand = level.getRandom();
        WorldParticleBuilder worldParticleBuilder = builder.setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)2.0f)).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.9f).build()).enableForcedSpawn().setLifetime(5).enableNoClip();
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder);
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, MalumNetworkedParticleEffectColorData color) {
        if (color == null) {
            return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType);
        }
        if (color.isSpiritBased()) {
            return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType, color.getSpirit());
        }
        return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType, color.getColor());
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, MalumSpiritType spiritType) {
        if (spiritType == null) {
            return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType);
        }
        return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType) {
        return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TRANSPARENT).setColorData(ColorParticleData.createGrayParticleColor((RandomSource)level.random)));
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, ColorParticleData colorData) {
        return WeaponParticleEffects.spawnSlamParticle(level, pos, particleType, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, Supplier<LodestoneWorldParticleType> particleType, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(new WorldParticleOptions(MalumParticles.SLAM));
        return WeaponParticleEffects.spawnSlamParticle(level, pos, builder);
    }

    public static ParticleEffectSpawner spawnSlamParticle(Level level, Vec3 pos, WorldParticleBuilder builder) {
        RandomSource rand = level.getRandom();
        WorldParticleBuilder worldParticleBuilder = builder.setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)2.0f)).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.9f).build()).enableForcedSpawn().setLifetime(5).enableNoClip();
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder);
    }
}

