/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.item;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MalumArmorTiers {
    public static final Holder<ArmorMaterial> SOUL_HUNTER = MalumArmorTiers.register("soul_hunter", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defense -> {
        defense.put(ArmorItem.Type.BOOTS, 1);
        defense.put(ArmorItem.Type.LEGGINGS, 3);
        defense.put(ArmorItem.Type.CHESTPLATE, 4);
        defense.put(ArmorItem.Type.HELMET, 2);
        defense.put(ArmorItem.Type.BODY, 2);
    }), 16, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.SOULWOVEN_SILK.get()}));
    public static final Holder<ArmorMaterial> SOUL_STAINED_STEEL = MalumArmorTiers.register("soul_stained_steel", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defense -> {
        defense.put(ArmorItem.Type.BOOTS, 2);
        defense.put(ArmorItem.Type.LEGGINGS, 6);
        defense.put(ArmorItem.Type.CHESTPLATE, 7);
        defense.put(ArmorItem.Type.HELMET, 3);
        defense.put(ArmorItem.Type.BODY, 4);
    }), 24, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 2.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.SOUL_STAINED_STEEL_PLATING.get()}));
    public static final Holder<ArmorMaterial> MALIGNANT_ALLOY = MalumArmorTiers.register("malignant_alloy", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), defense -> {
        defense.put(ArmorItem.Type.BOOTS, 3);
        defense.put(ArmorItem.Type.LEGGINGS, 6);
        defense.put(ArmorItem.Type.CHESTPLATE, 8);
        defense.put(ArmorItem.Type.HELMET, 3);
        defense.put(ArmorItem.Type.BODY, 4);
    }), 32, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, 2.0f, 0.1f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.MALIGNANT_PEWTER_PLATING.get()}));

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(ResourceLocation.withDefaultNamespace((String)name)));
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, defense.get(armoritem$type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)MalumMod.malumPath(name), (Object)new ArmorMaterial(enummap, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance));
    }
}

